/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "NyARTransMatResult.h"
#include <cmath>
namespace NyARToolkitCPP
{
	NyARTransMatResult::NyARTransMatResult()
	{
		this->has_value=false;
		return;
	}
    /**
     * ̊֐́A0-PI̊ԂŒlԂ܂B
     * @param o_out
     */
	void NyARTransMatResult::getZXYAngle(TNyARDoublePoint3d& o_out)
    {
        double sina = this->m21;
        if (sina >= 1.0)
        {
            o_out.x = NyAR_PI / 2;
            o_out.y = 0;
            o_out.z = atan2(-this->m10, this->m00);
        }
        else if (sina <= -1.0)
        {
            o_out.x = -NyAR_PI / 2;
            o_out.y = 0;
            o_out.z = atan2(-this->m10, this->m00);
        }
        else
        {
            o_out.x = asin(sina);
            o_out.z = atan2(-this->m01, this->m11);
            o_out.y = atan2(-this->m20, this->m22);
        }
    }

}
