package load;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public class NativeLoadTest {

	public static void main(String[] args) throws URISyntaxException,
			SecurityException, NoSuchFieldException, IllegalArgumentException,
			IllegalAccessException {

		URL url = NativeLoadTest.class.getResource("jogl_awt.dll");
		File file = new File(url.toURI());
		System.out.println(file);

		// System.loadLibrary("jogl_awt");

		ClassLoader cl = Thread.currentThread().getContextClassLoader();

		Field f = ClassLoader.class.getDeclaredField("usr_paths");
		System.out.println(f);
		f.setAccessible(true);
		String[] paths = (String[]) f.get(cl);

		String[] paths2 = new String[paths.length + 1];
		System.arraycopy(paths, 0, paths2, 0, paths.length);
		paths2[paths2.length - 1] = file.getParentFile().getAbsolutePath();

		for (String string : paths2) {
			System.out.println(string);
		}

		f.set(cl, paths2);
		f.setAccessible(false);

		System.loadLibrary("jogl_awt");

		System.out.println("load success");
	}
}
