/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
/// kgcalHelp.h : kgcal help
// =============================================================================
_title="項目間の演算";
_doc="\
mcal (項目間およびレコード間の計算)\n\
 \"c=\"パラメータで指定した計算式で計算をおこない、\n\
 \"a=\"パラメータで指定した項目名に出力する。関数には\n\
 日付時間関連、数値関連、文字列関連、\n\
 正規表現関連、論理関連、行項目関連がある。\n\
書式\n\
 mcal a= c= [-nfn] [-nfno] [-x] [precision=] [i=] [o=] [-help]\n\
パラメータ\n\
 a= 新項目名【必須】\n\
    新たに計算結果の出力として追加される項目の名前を指定する。\n\
    x,nfnオプション使用時は、項目番号(0～)で指定可能。\n\
 c= 計算式【必須】\n\
    用意された関数を組み合わせて計算する式を指定する。\n\
\n\
データ形式\n\
 mcalは用意された関数を組合せて柔軟な計算を行うことができるコマンドである。\n\
 その際、入出力のデータの型には注意する必要がある。\n\
 例えば2008年8月15日を\"20080815\"と表している日付データに対して、\n\
 17日を加えると結果は\"20080901\"となるが、\n\
 数値として17を加えると結果は\"20080832\"となるからである。\n\
 mcalには、数値、文字、日付(\"20080815\"など）、\n\
 時刻(\"20080815235959\"など）、\n\
 真偽（\"真\"あるいは\"偽\"）の5つの型がある。\n\
 \n\
定数\n\
 数値:20 0.55 1.5*e10\n\
 文字:\"abc\" \"日本語\"\n\
 日付:0d20080923 (0dyyyymmdd)\n\
 時刻:0t20080923121115 (0tyyyymmddhhmmss)\n\
 　注)日付を省略して指定することも可能。\n\
 　その場合は本日の日付が補完される。\n\
   0t121115 -補完-> \n\
    dtyyyymmddhh20080923121115(yyyymmddは本日日付)\n\
 真偽: 0b1(真) , 0b0(偽)\n\
\n\
項目\n\
 数値: ${項目名}\n\
 文字: $s{項目名}\n\
 日付: $d{項目名}\n\
 時刻: $t{項目名}\n\
   注)データ上の値がhhmmssの場合の日付は本日の日付が用いられる。\n\
 真偽: $b{項目名}\n\
   注)項目値の一文字目が'1'の時に真、'0'の時に偽、\n\
   その他の場合にはnullと解釈される。\n\
\n\
前行項目\n\
 前の行の項目の値を得る為に#{項目名}を利用する事ができる。\n\
 ${項目名}と同様にデータ型によって以下の５種類が用意されている。\n\
 数値: #{項目名}\n\
 文字: #s{項目名}\n\
 日付: #d{項目名}\n\
 時刻: #t{項目名}\n\
 真偽: #b{項目名}\n\
 さらに特殊項目として、項目名を省略すると前行の結果項目を指定できる。\n\
 if関数と組み合わせる事で、累計計算などが可能となる。\n\
\n\
四則演算\n\
 四則演算は以下の演算子を利用して行われる。\n\
 (データ型: N:数値, S:文字, D:日付, T:時刻, B:真偽)\n\
 【加算】項目1 +項目2 :\n\
   N (N,N), S (S,S), D (D,N), T (T,N)\n\
 【減算】項目1 -項目2 :\n\
   N (N,N), S (S,S), D (D,N), T (T,N), N (D,D), N (T,T)\n\
 【乗算】項目1 *項目2 :\n\
   N (N,N)\n\
 【除算】項目1 /項目2 :\n\
   N (N,N)\n\
 【剰余】項目1 %項目2 :\n\
   N (N,N)\n\
\n\
比較演算子\n\
 比較演算は以下の演算子を利用して行われる。\n\
 これは数値、文字、日付、時刻ともに同じ形式で利用可能である。\n\
 比較の結果が真ならばtrue、偽であればfalseを返す。\n\
 【大小関係】数1 >=数2 ,数1 <=数2 ,数1 >数2 ,数1 <数2\n\
 【等号・不等号】数1 ==数2 ,数1 !=数2\n\
 文字、日付、時刻の場合も記述方法は同じであるため省略する。\n\
\n\
論理演算子\n\
 2つ以上の真偽の組合せを用いた論理演算を実行する際に用いる。\n\
 比較の結果が真ならばtrue、偽であればfalseを返す。\n\
 条件1 &&条件2 :\n\
  AND演算（論理積） 条件がともに真のとき真,それ以外は偽\n\
 条件1｜｜条件2 :\n\
  OR演算（論理和）条件のいずれかが真のとき真,それ以外は偽\n\
 ￢条件:\n\
  NOT演算（否定）条件が偽であれば真、真であれば偽\n\
 if(条件，文字列1，文字列2）:\n\
  条件が真であれば文字列1を、偽であれば文字列2を返す\n\
\n\
型変換関数\n\
 データ型はそれぞれの型に\"2\"をはさんで記述することで、\n\
 左が入力型、右が出力型を表す\n\
 数値 s2n(文字),日付 s2d(文字),時刻 s2t(文字),\n\
 文字 n2s(数値),文字 d2s(日付)文字 t2s(時刻),\n\
 数値 b2n(真偽),文字 b2s(真偽),\n\
 真偽 n2b(数値),真偽 s2b(文字)\n\
\n\
数値の書式付き変換\n\
 format(数，フォーマット)\n\
\n\
数値関連\n\
 sum(数1,...,数n)\n\
  複数列の合計値を計算する関数\n\
 avg(数1,...,数n)\n\
  複数列の平均値を計算する関数\n\
 sqsum(数1,...,数n)\n\
  複数列の平方合計値を計算する関数\n\
 factorial(数)\n\
  階乗の計算をする関数\n\
 gcd(数,数)\n\
  2つの数の最大公約数を計算する関数\n\
 lcm(数,数)\n\
  2つの数の最小公倍数を計算する関数\n\
 sqrt(数)\n\
  ある項目の平方根を計算する関数\n\
 fract(数)\n\
  指定した数値の小数部分だけを表示する関数\n\
 int(数)\n\
  指定した数値の整数部分だけを表示する関数\n\
 min(数1,...,数n)\n\
  指定列の最小値を計算する関数\n\
 max(数1,...,数n)\n\
  指定列の最大値を計算する関数\n\
 minf()\n\
  利用可能な最小数を出力する関数\n\
 maxf()\n\
  利用可能な最大数を出力する関数\n\
 abs(数)\n\
  ある項目の絶対値を計算する関数\n\
 round(数,数)\n\
  指定列の指定桁で四捨五入する関数\n\
 power(数,数)\n\
  指定列のべき乗を計算する関数\n\
 floor(数,数)\n\
  指定列の指定桁で切捨てて０に近い整数にする関数\n\
 ceil(数,数)\n\
  指定列の指定桁で切上げ０に遠い整数にする関数\n\
 exp(数)\n\
  eを底とするべき乗を計算する関数\n\
 ln(数)\n\
  自然対数を計算する関数\n\
 log(数,数)\n\
  対数を計算する関数\n\
 log2(数)\n\
  2を底とする対数を計算する関数\n\
 log10(数)\n\
  10を底とする対数を計算する関数\n\
 product(数1,...,数n)\n\
  複数列の積を計算する関数\n\
 sign(数)\n\
  ある項目の正負符号を判定する関数\n\
 diste(数1,...,数n,数n+1,...,数2n)\n\
  n次元の2点の座標間のユークリッド距離を計算する関数\n\
 distm(数1,...,数n,数n+1,...,数2n)\n\
  n次元の2点の座標間のマンハッタン距離を計算する関数\n\
 disth(数1,...,数n,数n+1,...,数2n)\n\
  n次元の2点の座標間のハミング距離を計算する関数\n\
 heron(数1,...,数n,数n+1,...,数2n,数2n+1,...,数3n)\n\
  n次元の3点の座標によって作られる3角形の面積を計算する関数\n\
 pi()\n\
  PIを出力する\n\
 e()\n\
  ネイピア数を出力する\n\
 rand(最小値，種類数，シード)\n\
  一様乱数を発生させる関数\n\
 nrand(平均値,標準偏差,シード)\n\
  正規乱数を発生させる関数\n\
\n\
三角関数関連\n\
 acos(数)\n\
  ある項目のアークコサインを計算する関数\n\
 asin(数)\n\
  ある項目のアークサインを計算する関数\n\
 atan(数)\n\
  ある項目のアークタンジェントを計算する関数\n\
 atan2(数,数)\n\
  x,y座標と原点を結ぶ線分とx軸とが作る角度を計算する関数\n\
 cos(数)\n\
  ある項目のラジアンに相当するコサインを計算する関数\n\
 sin(数)\n\
  ある項目のラジアンに相当するサインを計算する関数\n\
 tan(数)\n\
  ある項目のラジアンに相当するタンジェントを計算する関数\n\
 degree(数)\n\
  ある項目の値のラジアンを角度に変換する関数\n\
 radian(数)\n\
  ある項目の値の角度をラジアンに変換する関数\n\
 cosh(数)\n\
  双曲線余弦(ハイパーボリックコサイン)を計算する関数\n\
 sinh(数)\n\
  双曲線正弦(ハイパーボリックサイン)を計算する関数\n\
 tanh(数)\n\
  双曲線逆正接(ハイパーボリックタンジェントの逆関数)を計算する関数\n\
\n\
文字列関連\n\
 cat(トークン，文1，...，文m)\n\
  複数の文字列を指定するトークンで結合する\n\
 length(文)\n\
  文字列の長さを計算して出力する\n\
 lengthw(文)\n\
  文字列の文字数を計算して出力する\n\
 fixlen(文，数，文字，文)\n\
  文字列を指定桁固定長に変換する\n\
 fixlenw(文，数，文字，文)\n\
  文字列を指定桁固定長(マルチバイト文字ベース)に変換する。\n\
  fixlen()のマルチバイト文字を対象とした関数。\n\
 right(文，数)\n\
  文字列を右から指定数取り出す\n\
 rightw(文，数)\n\
  文字列を右から指定数（マルチバイト文字ベース）取り出す\n\
 left(文，数)\n\
  文字列を左から指定数取り出す\n\
 leftw(文，数)\n\
  文字列を左から指定文字数取り出す\n\
 mid(文，数，数)\n\
  文字列を右から開始位置と抽出長を指定して抽出する\n\
 midw(文，数，数)\n\
  文字列を右から開始位置と抽出長(マルチバイト文字ベース)を指定して抽出する\n\
 toupper(文)\n\
  文字列をすべて大文字に変更する\n\
 tolower(文)\n\
  文字列をすべて小文字に変更する\n\
 capitalize(文)\n\
  文字列の先頭文字のみ大文字に変更する\n\
 isinor(検索文，文1，...，文m)\n\
  指定文字列の該当チェック\n\
 isinand(検索文，文1，...，文m)\n\
  指定文字列の該当チェック\n\
 hasspace(文)\n\
  文字列内の空白の有無をチェックする\n\
 hasspacew(文)\n\
  文字列内の空白(全角半角空白)の有無をチェックする\n\
\n\
正規表現関連\n\
 regexs(文,正規表現)\n\
  文字列に対してい正規表現がマッチする部分文字列があれば真を返す\n\
 regexm(文,正規表現)\n\
  文字列に対してい正規表現が完全にマッチすれば真を返す\n\
 regexrep(文,正規表現,文)\n\
  文字列に対して正規表現がマッチする部分を指定文字列に置換する\n\
 regexlen(文,正規表現)\n\
  文字列に対して正規表現がマッチした長さを返す\n\
 regexpos(文,正規表現)\n\
  文字列に対して正規表現がマッチした先頭位置を返す\n\
 regexstr(文,正規表現)\n\
  文字列に対して正規表現がマッチする部分文字列を返す\n\
 regexpfx(文,正規表現)\n\
  文字列に対して正規表現がマッチした部分文字列の\n\
  直前までの文字列を左から出力する\n\
 regexsfx(文,正規表現)\n\
  文字列に対して正規表現がマッチした部分文字列の\n\
  直後から右方向に最後までの文字列を出力する\n\
\n\
日付時間関連\n\
 today()\n\
  本日の日付を出力する。\n\
  日付フォーマットは環境変数KGDATEFMT\n\
 now()\n\
  現在時刻を表示する\n\
 tseconds(日時)\n\
  0:00:00から現在時刻までの経過秒数を取得\n\
 d2uxt(日)\n\
  通常の日付をUNIX時刻に変換する\n\
  UNIX時刻は1970年1月1日00時00分00秒(GMT)を起点（0）とし、\n\
  経過秒数を整数で表したものである。\n\
 t2uxt(日時)\n\
  通常の日付をUNIX時刻に変換する\n\
 uxt2d(数値)\n\
  UNIX時刻を通常の日付に変換する\n\
 uxt2t(数値)\n\
  UNIX時刻を通常の日時に変換する\n\
 leapyear(日)\n\
  日を入力し閏年かどうかを判定する。\n\
  閏年であればtrue、それ以外にはfalseを返す。\n\
 leapyear(日時)\n\
  日時を入力し閏年かどうかを判定する。\n\
  閏年であればtrue、それ以外にはfalseを返す\n\
 year(日)\n\
  日を入力し西暦年を抽出して表示する\n\
 year(日時)\n\
  日時を入力し西暦年を抽出して表示する\n\
 month(日)\n\
  日を入力し月を抽出して表示する\n\
 month(日時)\n\
  日時を入力し月を抽出して表示する\n\
 emonth(日)\n\
  日を入力し月の英語表記を表示する\n\
 emonth(日時)\n\
  日時を入力し月の英語表記を表示する\n\
 esmonth(日)\n\
  日を入力し月の短縮英語表記を表示する\n\
 esmonth(日時)\n\
  日時を入力し月の短縮英語表記を表示する\n\
 day(日)\n\
  日を入力し日付を数値表示する\n\
 day(日時)\n\
  日時を入力し日付を数値表示する\n\
 week(日)\n\
  日を入力し週を数値表示する。\n\
  1年が始まってから第何周目なのかを、日から計算して表示する。\n\
 week(日時)\n\
  日時を入力し週を数値表示する。\n\
  1年が始まってから第何周目なのかを、日時から計算して表示する。\n\
 dow(日)\n\
  日を入力し曜日を数値で表示する(0:日曜)\n\
 dow(日時)\n\
  日時を入力し曜日を数値で表示する(0:日曜)\n\
 edow(日)\n\
  日を入力し曜日の英語表記を表示する\n\
 edow(日時)\n\
  日時を入力し曜日の英語表記を表示する\n\
 esdow(日)\n\
  日を入力し曜日の短縮英語表記を表示する\n\
 esdow(日時)\n\
  日時を入力し曜日の短縮英語表記を表示する\n\
 hours(日時)\n\
  日時を入力し時間を数値表示する\n\
 minutes(日時)\n\
  日時を入力し分を数値表示する\n\
 seconds(日時)\n\
  日時を入力し秒を数値表示する\n\
 d2julian(日)\n\
  日付からユリウス通日を求める\n\
  ユリウス通日は紀元前4713年1月1日正午（世界標準時による）からの日数である。\n\
  ただしグリゴリオ歴は1400-1-1～9999-12-31が有効範囲のため、\n\
  それに対応するユリウス通日の有効値範囲は2232300～5373484となる。\n\
  その範囲外ではnull出力となる。\n\
 t2julian(日時)\n\
  日時からユリウス通日を求める\n\
  変換の際に指定した日時の時刻は切り捨てられ，日付のみが変換の対象となる\n\
 julian2d(数)\n\
  ユリウス通日から日付を求める\n\
 julian2t(数)\n\
  ユリウス通日から時刻を求める\n\
行項目関連\n\
 line()\n\
  mcalで行っている処理行番号の取得\n\
 fldcnt()\n\
  入力ファイルの項目数確認\n\
 top()\n\
  先頭項目の確認。一行目の項目であれば真を返す。\n\
例\n\
 mcal c='(${金額}+100)' a=\"金額2\" i=dat.csv o=mcal_rsl.csv\n\
 mcal c='(${金額}>=1000)' a=\"1000円以上\" i=dat.csv o=mcal_ncmp_rsl.csv\n\
 mcal c='(${金額}>=500||${数量}>=2)' a=\"購買大\" i=dat.csv o=mcal_op_rsl1.csv\n\
 mcal c='sum(${A},${B},${C},${D},${E},${F},${G},${H},${I},${J})' a=\"合計値\" i=rnd.csv o=osum.csv\n\
 mcal c='acos(${rad1})' a=\"アークコサイン\" i=tri.csv o=oacos.csv\n\
 mcal c='length($s{c1})' a=\"文字列長\" i=char.csv o=olength.csv\n\
 mcal c='regexs($s{c1},\"[m,o,d,u]\")' a=\"マッチ\" i=char.csv o=oregexs.csv\n\
 mcal c='tseconds($t{時間})' a=\"経過秒数\" i=date.csv o=otseconds.csv\n\
 mcal c='line()' a=\"処理番号\" i=dat.csv o=oline.csv\n\
";

