/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
/// kgsimHelp.h : kgsim help
// =============================================================================
_title="項目間類似度計算";
_doc="\
msim (二変数間の類似の計算)\n\
 \"f=\"パラメータで指定した項目の二変数間の類似度(距離)を\n\
 \"c=\"パラメータで指定した類似度(距離)関数で計算し\n\
 類似度行列として出力する。\n\
書式\n\
 msim c= f= [a=] [k=] [-d] [bufcount=] [-nfn] [-nfno] [-x] [precision=] [i=] [o=] [-help]\n\
パラメータ\n\
 k= キー項目名リスト(複数項目指定可)【任意】\n\
    ここで指定された項目を単位として求める。\n\
    (注意）指定する場合は事前に\"k=\"パラメータで指定する\n\
    計算の単位となる項目順に並べ替えておく必要がある。\n\
 f= 項目名リスト(複数項目指定可)【必須】\n\
    ここで指定された項目全ての二項目間の類似度を求める。\n\
    x,nfnオプション使用時は、項目番号(0～)で指定。\n\
 c= 類似度(距離)名リスト(複数項目指定可)【必須】\n\
    次項に示した類似度(距離)名を指定する。\n\
    項目名は以下のように，(:)コロンに続けて指定して変更可能。\n\
    コロンに続く名称を省略した場合は類似度(距離)\n\
    関数名がそのまま項目名として利用される。\n\
    類似度(距離):\n\
     covar/ucovar/pearson/spearman/kendall/euclid/cosine/\n\
     cityblock/hamming/chi/phi/jaccard/supportr/lift\n\
オプション\n\
 -d 対角行列、上三角行列を出力する。\n\
    \"-d\"オプションが指定されないと類似度行列の下三角行列のみ出力されるが、\n\
    \"-d\"オプションを指定することにより対角行列及び上三角行列も出力される。\n\
類似度(距離)リスト\n\
 類似度\n\
　covar    共分散\n\
　ucovar   不偏共分散 \n\
　pearson  ピアソンの積率相関係数 \n\
　spearman スピアマンの順位相関係数\n\
　kendall  ケンドールの順位相関係数 \n\
　cosine   コサイン\n\
  chi      カイ２乗値 \n\
  phi      ファイ係数 \n\
  jaccard  ジャックカード係数 \n\
  support  支持度\n\
  lift     リフト値\n\
 距離\n\
  euclid    ユークリッド距離(数値)\n\
  cityblock 都市ブロック距離\n\
  hamming   ハミング距離\n\
例\n\
msim c=pearson,cosine f=x,y,z i=dat.csv o=rsl.csv\n\
msim c=pearson,cosine f=x,y,z -d i=dat.csv o=rsl.csv\n\
msim k=key c=pearson,cosine f=x,y,z i=dat.csv o=rs1.csv\n\
msim c=hamming,phi f=x,y,z i=dat.csv o=rsl.csv\n\
msim c=hamming:ハミング距離,phi:ファイ係数 a=変数1,変数2 f=x,y,z i=dat.csv o=rsl.csv\n\
";

