/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
// kgcount.cpp 行カウントクラス
// =============================================================================
#include <cstdio>
#include <kgcount.h>
#include <kgError.h>

using namespace std;
using namespace kglib;
using namespace kgmod;

// -----------------------------------------------------------------------------
// コンストラクタ(モジュール名，バージョン登録)
// -----------------------------------------------------------------------------
kgCount::kgCount(void)
{
	#ifdef ENG_FORMAT
		#include <help/en/kgcountHelp.h>
	#else
		#include <help/jp/kgcountHelp.h>
	#endif
	_name    = "kgcount";
	_version = "1.0";
}
// -----------------------------------------------------------------------------
// パラメータセット＆入出力ファイルオープン
// -----------------------------------------------------------------------------
void kgCount::setArgs(void)
{
	// パラメータチェック
	_args.paramcheck("a=,i=,o=,k=");

	// 入出力ファイルオープン
	_iFile.open(_args.toString("i=",false), _env,_nfn_i);
  _oFile.open(_args.toString("o=",false), _env,_nfn_o);
	_iFile.read_header();

	// a= 追加文字列
	_addstr = _args.toString("a=",false);
	if(_addstr.empty()&& _nfn_o==false){
		throw kgError("parameter a= is mandatory");
	}

	// k= 項目引数のセット
	vector<kgstr_t> vs = _args.toStringVector("k=",false);
	_kField.set(vs,  &_iFile, _fldByNum);
}
// -----------------------------------------------------------------------------
// 実行
// -----------------------------------------------------------------------------
void kgCount::run(void) try 
{
	// パラメータセット＆入出力ファイルオープン
	setArgs();

	// 入力ファイルにkey項目番号をセットする．
	_iFile.setKey(_kField.getNum());

	// 項目名の出力
  _oFile.writeFldName(_iFile,_addstr);

	size_t cnt = 0;
	// データ集計＆出力
	while(_iFile.read()!=EOF){		
		//keybreakしたら出力&cnt初期化
		if( _iFile.keybreak() ){
			_oFile.writeFld(_iFile.getOldFld(),_iFile.fldSize(),cnt,false);
			if((_iFile.status() & kgCSV::End )) break;
			cnt=0;				
		}
		cnt++;
	}

	// 終了処理
	_iFile.close();
	_oFile.close();
	successEnd();

}catch(kgError& err){
	errorEnd(err);
}
