/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
// kgmvavg.h 移動平均クラス
// =============================================================================
#pragma once
#include <vector>
#include <kgmod.h>
#include <kgArgFld.h>
#include <kgCSV.h>
#include <kgCSVout.h>

using namespace kglib;

namespace kgmod { ////////////////////////////////////////////// start namespace

class kgMvavg : public kgMod {

	// 引数
	kgArgFld kField_; // k=
	kgArgFld fField_; // f=
	kgCSVkey iFile_;  // i=
	kgCSVout oFile_;  // o=
	size_t   term_;   // t=
	bool     weighted_;	 // -weighted
	double   exp_;   		 // exp=
	double   total_; 		 // 1+2+...+term_
	double   count_; 		 //
	size_t   skip_; 		 //
	double   alpha_; 		 //

  void setArgs(void);

	vector<double> val_;
	vector<double> sum_;
	vector<double> num_;
	vector<double> avg_;
	bool           simple_;
	void outputS(size_t pointer);
	void simpleMA(void);
	void outputW(size_t pointer, bool filled);
	void weightedMA(void);
	void outputE(size_t pointer);
	void expMA(void);

	// CSV項目出力
	void writeFld(char** fld, const vector<int>* flg, const vector<double>* val);

public:
  // コンストラクタ
	 kgMvavg(void);
	~kgMvavg(void){}

	// 処理行数取得メソッド
	size_t iRecNo(void) const { return iFile_.recNo(); }
	size_t oRecNo(void) const { return oFile_.recNo(); }

	//実行メソッド
	void run(void);

};

}
