// VSOP - Header (SAPPORO-1.00M)
// Shin-ichi MINATO (Jun. 22, 2006)
#include <fstream>
#define PROMPT "vsop> "
#define DOCUMENT "vsop.help"

int yyparse();

struct VarEntry;

class VarTable
{
  int _used;
  int _hashsize;
  VarEntry* _wheel;
  VarEntry** _index;

  void Enlarge(void);
  VarEntry* GetEntry(char *);
public:
  VarTable(int size = 64);
  ~VarTable(void);
  int GetID(char *);
  char* GetName(int);
  int GetValue(int);
  int GetGID(int);
  void SetB(char *, int);
  void SetB(char *, int, int);
  void SetT(char *, int);
  void SetT0(int, char *);
  void SetT(char *, int, int);
  int Used(void);
};

struct FuncEntry;
class CtoI;

class FuncTable
{
  int _used;
  int _hashsize;
  FuncEntry* _wheel;

  void Enlarge(void);
  FuncEntry* GetEntry(char *);
public:
  FuncTable(int size = 256);
  ~FuncTable(void);
  int CheckNew(char *);
  CtoI& GetCtoI(char *);
  void Set(char *, CtoI &);
  int Used(void);
};

class BOut
{
  short _column;
	ostream*	_ffp;
	ofstream	_fp;
	bool			_isStdout;
public:
	BOut(void);
	BOut(char * str);
	~BOut();
  BOut& operator <<(char *);
  void Delimit(void);
  void Return(void);
  void Set(char *);
  void Unset(void);
};

extern VarTable VTable;
extern FuncTable FTable;
extern BOut bout;

extern void yyerror(char *);

extern int PrintCtoI(CtoI);
extern int PrintCtoI_16(CtoI);
extern int PrintDigital(CtoI);
extern int PrintCase(CtoI);
extern int MapAll(CtoI);
extern int MapSel(CtoI);

extern int PrintDecomp(CtoI);
extern int PrintDecompDot(CtoI);
