/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text.html;

import com.sk_jp.text.AttributeMap;
import com.sk_jp.text.AttributeTokenizer;
import com.sk_jp.text.html.HTMLHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class HTMLLex {
    private HTMLHandler handler;

    public HTMLLex(HTMLHandler hTMLHandler) {
        this.handler = hTMLHandler;
    }

    public void parse(Reader reader) throws IOException {
        int n;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        block0: while ((n = reader.read()) != -1) {
            if (n != 60) {
                stringBuffer.append((char)n);
                continue;
            }
            if (stringBuffer.length() > 0) {
                this.handler.text(new String(stringBuffer));
            }
            stringBuffer.setLength(0);
            stringBuffer.append((char)n);
            n = reader.read();
            if (n == -1) break;
            stringBuffer.append((char)n);
            boolean bl = n == 47;
            if (n == 63) {
                // empty if block
            }
            if (n == 33) {
                n = reader.read();
                if (n == -1) break;
                stringBuffer.append((char)n);
                if (n != 45) continue;
                n = reader.read();
                if (n == -1) break;
                stringBuffer.append((char)n);
                if (n != 45 || !this.consumeComment(reader, stringBuffer)) continue;
                break;
            }
            while ((n = reader.read()) != -1) {
                stringBuffer.append((char)n);
                if (n == 34 && AttributeTokenizer.consumeQuote(reader, stringBuffer, '\"') || n == 39 && AttributeTokenizer.consumeQuote(reader, stringBuffer, '\'')) break block0;
                if (n != 62) continue;
                if (!this.parseTagAndCallHandler(stringBuffer, bl)) continue block0;
                stringBuffer.setLength(0);
                continue block0;
            }
            break block0;
        }
        if (stringBuffer.length() > 0) {
            this.handler.text(new String(stringBuffer));
        }
    }

    private boolean parseTagAndCallHandler(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            return this.handler.leave(new String(stringBuffer).substring(2, stringBuffer.length() - 1).trim().toLowerCase());
        }
        AttributeTokenizer attributeTokenizer = new AttributeTokenizer(stringBuffer.substring(1, stringBuffer.length() - 1));
        return this.handler.enter(attributeTokenizer.next(), new AttributeMap(stringBuffer.substring(1, stringBuffer.length() - 1)));
    }

    private boolean consumeComment(Reader reader, StringBuffer stringBuffer) throws IOException {
        while (true) {
            int n;
            if ((n = reader.read()) == -1) {
                return true;
            }
            stringBuffer.append((char)n);
            if (n != 45) continue;
            n = reader.read();
            if (n == -1) {
                return true;
            }
            stringBuffer.append((char)n);
            if (n != 45) continue;
            n = reader.read();
            if (n == -1) {
                return true;
            }
            stringBuffer.append((char)n);
            if (n == 62) break;
        }
        return false;
    }

    public static void main(String[] stringArray) throws IOException {
        new HTMLLex(new HTMLHandler(){

            public void text(String string) {
                System.out.println("text = [" + string + "]");
            }

            public boolean enter(String string, AttributeMap attributeMap) {
                System.out.println("Tag_start = [" + string + "]");
                System.out.println("Tag_attributes = " + attributeMap);
                return true;
            }

            public boolean leave(String string) {
                System.out.println("Tag_end = [" + string + "]");
                return true;
            }
        }).parse(new InputStreamReader(System.in, "JISAutoDetect"));
    }
}

