/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.MultipartUtility;
import com.sk_jp.mail.PartHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

public class AttachmentsExtractor
implements PartHandler {
    public static final int MODE_IGNORE_MESSAGE = 1;
    public static final int MODE_IGNORE_INLINE = 2;
    private final int mode;
    private final List attachmentParts = new ArrayList();

    public AttachmentsExtractor() {
        this(0);
    }

    public AttachmentsExtractor(int n) {
        this.mode = n;
    }

    public boolean processPart(Part part, ContentType contentType) throws MessagingException, IOException {
        if (part.isMimeType("message/*")) {
            if ((this.mode & 1) != 0) {
                return true;
            }
            this.attachmentParts.add(part);
            return true;
        }
        if (MailUtility.getFileName(part) == null) {
            return true;
        }
        if ((this.mode & 2) != 0 && "inline".equalsIgnoreCase(part.getDisposition())) {
            return true;
        }
        this.attachmentParts.add(part);
        return true;
    }

    public int getCount() {
        return this.attachmentParts.size();
    }

    public String[] getFileNames() throws MessagingException {
        String[] stringArray = new String[this.getCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getFileName(i);
        }
        return stringArray;
    }

    public String getFileName(int n) throws MessagingException {
        Part part = (Part)this.attachmentParts.get(n);
        String string = MailUtility.getFileName(part);
        if (string == null) {
            string = part.isMimeType("message/*") ? "message" + n + ".eml" : "file" + n + ".tmp";
        }
        return string;
    }

    public String getContentType(int n) throws MessagingException {
        return MailUtility.unfold(((Part)this.attachmentParts.get(n)).getContentType());
    }

    public int getSize(int n) throws MessagingException {
        return ((Part)this.attachmentParts.get(n)).getSize();
    }

    public InputStream getInputStream(int n) throws MessagingException, IOException {
        return ((Part)this.attachmentParts.get(n)).getInputStream();
    }

    public void writeTo(int n, OutputStream outputStream) throws MessagingException, IOException {
        int n2;
        InputStream inputStream = this.getInputStream(n);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), System.in);
        AttachmentsExtractor attachmentsExtractor = new AttachmentsExtractor();
        MultipartUtility.process((Part)mimeMessage, attachmentsExtractor);
        for (int i = 0; i < attachmentsExtractor.getCount(); ++i) {
            System.out.println("Attachment no : " + i);
            System.out.println("Filename = " + attachmentsExtractor.getFileName(i));
            System.out.println("******************");
            attachmentsExtractor.writeTo(i, System.out);
        }
    }
}

