package jp.sourceforge.observoice.network.requestmethod;

import java.io.IOException;

import jp.sourceforge.observoice.network.HttpClient;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * Observoiceのクライアントからサーバーへ送信するGETリクエストメソッドデータを表す抽象クラス。
 * 実際のリクエストメソッドのデータは子クラスになる。
 * 
 * @author rtakizawa
 */
public abstract class ObsvGetRequestMethod implements ObsvRequestMethod {

    /**
     * Observoiceリクエストメソッドの送信
     * 
     * @return
     * サーバーからのレスポンス
     * またはエラーレスポンス
     * @throws IOException 
     */
    public ObsvResponseObject send() throws IOException {
        HttpClient hc = new HttpClient();
        String res = hc.get(createUrlString());

        return createResponseObject(res);
    }
}
