package jp.sourceforge.observoice;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionFilter implements Filter {

    private static final Logger logger = LoggerFactory
            .getLogger(ExtensionFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        chain.doFilter(new Wrapper(httpRequest), response);
    }

    @Override
    public void destroy() {
    }

    private static class Wrapper extends HttpServletRequestWrapper {

        public Wrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public String getRequestURI() {
            return FilenameUtils.removeExtension(super.getRequestURI());
        }

        @Override
        public Enumeration<?> getHeaders(String name) {
            if ("accept".equals(name)) {
                String ext = FilenameUtils.getExtension(super.getRequestURI());
                if ("json".equals(ext)) {
                    logger.debug("Rewriting accept headers into 'application/json'");
                    Vector<String> values = new Vector<String>();
                    values.add("application/json");
                    return values.elements();
                }
            }
            return super.getHeaders(name);
        }
    }

}
