package jp.sourceforge.observoice.resources;

import java.util.Date;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;

import jp.sourceforge.observoice.entity.Comment;
import jp.sourceforge.observoice.resources.params.DateParam;
import jp.sourceforge.observoice.service.CommentService;
import jp.sourceforge.observoice.util.DateFormatUtil;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/courses/{courseId}/comments")
public class CommentResource extends S2Resource {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Binding
    private CommentService commentService;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public JSONObject getComments(@PathParam("courseId") int courseId,
            @QueryParam("since") DateParam since,
            @QueryParam("until") DateParam until,
            @DefaultValue("100") @QueryParam("count") int count)
            throws JSONException {
        Date s = since != null ? since.getDate() : null;
        Date u = until != null ? until.getDate() : null;
        List<Comment> comments = commentService.getComments(courseId, s, u,
                count);

        JSONObject ret = new JSONObject();
        JSONArray ca = new JSONArray();
        ret.put("result", ca);
        for (Comment c : comments) {
            ca.put(encodeComment(c));
        }
        ret.put("count", comments.size());

        return ret;
    }

    @POST
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    @Path("/post")
    public JSONObject postComment(@PathParam("courseId") int courseId,
            @FormParam("userId") String userId,
            @FormParam("type") Integer type,
            @FormParam("content") String content) throws JSONException {
        if (userId == null || type == null) {
            throw new WebApplicationException(Status.BAD_REQUEST);
        }

        Comment c = commentService.postComment(userId, type, content);

        return encodeComment(c);
    }

    private JSONObject encodeComment(Comment c) throws JSONException {
        JSONObject ret = new JSONObject();
        ret.put("userId", c.userId);
        ret.put("type", c.type);
        ret.put("content", c.content == null ? JSONObject.NULL : c.content);
        ret.put("created", DateFormatUtil.formatRfc2822(c.created));
        return ret;
    }

}
