package jp.sourceforge.observoice.dao;

import java.io.Serializable;
import java.util.List;

import jp.sourceforge.observoice.entity.Course;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.Query;
import org.seasar.dao.annotation.tiger.S2Dao;
import org.seasar.dao.annotation.tiger.SqlFile;

@S2Dao(bean = Course.class)
public interface CourseDao extends Serializable {

    List<Course> selectAll();

    @Query("course_id = ?")
    Course select(int courseId);

    @SqlFile
    @Arguments({ "day", "period", "q", "count" })
    List<Course> search(int day, int period, String q, int count);

}
