package jp.sourceforge.observoice.service;

import java.util.List;

import jp.sourceforge.observoice.dao.CourseDao;
import jp.sourceforge.observoice.dao.CourseScheduleDao;
import jp.sourceforge.observoice.entity.Course;
import jp.sourceforge.observoice.entity.CourseSchedule;

import org.seasar.framework.container.annotation.tiger.Binding;

public class CourseService {

    @Binding
    private CourseDao courseDao;
    @Binding
    private CourseScheduleDao courseScheduleDao;

    public List<Course> search(int day, int period, String q, int count) {
        return courseDao.search(day, period, q, count);
    }

    public Course find(int courseId) {
        return courseDao.select(courseId);
    }

    public List<CourseSchedule> getCourseSchedule(int courseId) {
        return courseScheduleDao.selectByCourseId(courseId);
    }

}
