package jp.sourceforge.observoice.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatUtil {

    private static final String RFC2822_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";

    private DateFormatUtil() {
    }

    /**
     * 文字列(RFC2822)を日付に変換する
     * 
     * @param value
     *            日付の文字列表現(RFC2822)
     * @return 変換結果の日付
     * @throws ParseException
     */
    public static Date parseRfc2822(String value) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(RFC2822_FORMAT);
        return format.parse(value);
    }

    /**
     * 日付を文字列(RFC2822)に変換する
     * 
     * @param date
     *            変換する日付
     * @return 日付の文字列表現(RFC2822)
     */
    public static String formatRfc2822(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(RFC2822_FORMAT);
        return format.format(date);
    }

}
