/*
 Copyright (c) 2009, hkrn All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 Redistributions of source code must retain the above copyright notice, this
 list of conditions and the following disclaimer. Redistributions in binary
 form must reproduce the above copyright notice, this list of conditions and
 the following disclaimer in the documentation and/or other materials
 provided with the distribution. Neither the name of the hkrn nor
 the names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission. 
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
 */

//
//  TestMMLCompile.m
//  OCMML
//
//  Created by hkrn on 09/04/28.
//  Copyright 2009 hkrn. All rights reserved.
//
//  $Id: TestMMLCompile.m 84 2009-05-02 12:48:54Z hikarin $
//

#import "TestMMLCompile.h"

@implementation TestMMLCompile

- (void)writeToFile:(NSObject *)tracks
              mmlId:(int)mmlId
{
    NSError *error = nil;
    SBJSON *json = [[SBJSON alloc] init];
    NSString *serialized = [json stringWithObject:tracks
                                            error:&error];
    if (error == nil) {
        NSString *path = [NSString stringWithFormat:@"%@/.data/mml/%d.json", NSHomeDirectory(), mmlId];
        if (![serialized writeToFile:path
                          atomically:YES
                            encoding:NSUTF8StringEncoding
                               error:&error])
        {
            [json release];
            STFail([error localizedDescription]);
        }
    }
    else {
        [json release];
        STFail([error localizedDescription]);
    }
}

- (void)testCompile
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
    NSString *basePath = [NSString stringWithFormat:@"%@/MML", [paths objectAtIndex:0]];
    NSString *srcPath = [NSString stringWithFormat:@"%@/Source/%d.mml", basePath, MML_ID];
    NSString *testPath = [NSString stringWithFormat:@"%@/Test/%d.json", basePath, MML_ID];
    NSError *error = nil;
    MMLEngine *engine = [[MMLEngine alloc] init];
    SBJSON *json = [[SBJSON alloc] init];
    NSString *src = [NSString stringWithContentsOfFile:srcPath
                                              encoding:NSUTF8StringEncoding
                                                 error:&error];
    if (error != nil) {
        STFail([error localizedDescription]);
        goto finalize;
    }
    [engine compile:src];
    [engine stop];
    NSArray *tracksInTarget = [engine dumpTracks];
    NSString *test = [NSString stringWithContentsOfFile:testPath
                                               encoding:NSUTF8StringEncoding
                                                  error:&error];
    if (error != nil) {
        STFail([error localizedDescription]);
        goto finalize;
    }
    NSArray *tracksInTest = [json objectWithString:test
                                             error:&error];
    if (error != nil) {
        STFail([error localizedDescription]);
        goto finalize;
    }
    int i = 0, j = 0;
    for (NSArray *trackInTest in tracksInTest) {
        NSArray *trackInTarget = [tracksInTarget objectAtIndex:i];
        for (NSDictionary *eventsInTest in trackInTest) {
            NSMutableDictionary *eventsInTarget = [trackInTarget objectAtIndex:j];
            NSString *statusInTest = [eventsInTest objectForKey:@"status"];
            NSString *statusInTarget = [eventsInTarget objectForKey:@"status"];
            if (![statusInTest isEqualToString:statusInTarget]) {
                NSString *message = [NSString stringWithFormat:@"%@ and %@ should equals at tracks[%d][%d] in %d.mml",
                                     statusInTarget, statusInTest, i, j, MML_ID];
                STFail(message);
                goto finalize;
            }
            [eventsInTarget removeObjectForKey:@"status"];
            for (NSString *key in eventsInTarget) {
                id eventsInTestValue = [eventsInTest objectForKey:key];
                id eventsInTargetValue = [eventsInTarget objectForKey:key];
                if (![eventsInTestValue isEqual:eventsInTargetValue]) {
                    NSString *message = [NSString stringWithFormat:@"%@ and %@ should equals at tracks[%d][%d][%@] (%@) in %d.mml",
                                         eventsInTargetValue, eventsInTestValue, i, j, key, statusInTarget, MML_ID];
                    STFail(message);
                    goto finalize;
                }
            }
            j++;
        }
        j = 0;
        i++;
    }
finalize:
    [json release];
    [engine release];
    [self writeToFile:tracksInTarget
                mmlId:MML_ID];
}

@end
