#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	ファイル名	：	/Application/Include/Common.mk
#	概要		：	アプリケーションが共通で使用するメイクファイルです。
#	詳細		：	アプリケーションのMakefileが必ずインクルードするサブMakefileです。
#	責任者		：	佐合 秀昭
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#



#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	変数定義
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
ROOT				= ../../

NAME				= $(APL_NAME:.apl=)

#共通ディレクトリ
COMMON_DIR			= ../Common/

#スタートアップオブジェクト
STARTUP				= $(COMMON_DIR)Startup/.Startup.o

#リンカスクリプトファイル
APPLI_LS_NAME		= $(COMMON_DIR)Appli.ls


#リンクオプション
#-nostdlib	: 標準のシステムライブラリとスタートアップファイルを使用しない。
#-static	: 動的リンクをしない。
#-L			: ライブラリを探索するディレクトリのリストに追加する。
#-l			: リンクするファイルリストに加える。lib〜.aではさまれたファイル名になる。
#-Map		: リンクマップを出力する。
LINK_OPTIONS		+= -T $(APPLI_LS_NAME)
LINK_OPTIONS		+= -nostdlib
LINK_OPTIONS		+= -static
LINK_OPTIONS		+= -L$(INC_DIR_ML)
LINK_OPTIONS		+= -L$(INC_DIR_CSTD)
LINK_OPTIONS		+= -l$(ML_LIB_NAME)
LINK_OPTIONS		+= -l$(CSTD_LIB_NAME)
LINK_OPTIONS		+= -Map $(MAP_NAME)



#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	インクルード
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
include	$(ROOT)Common.mk



#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	コマンド
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#*******************************************************************************
#	デフォルト動作
#*******************************************************************************
PHONY += default
default:
	@make -s _$@
_default: _application


#*******************************************************************************
#	アプリケーション作成
#*******************************************************************************
PHONY += application apl
application apl:
	@make -s _$@
_application _apl: $(APL_NAME)


#*******************************************************************************
#	アプリケーション再作成
#*******************************************************************************
PHONY += remake
remake:
	@make -s _$@
_remake: _delete _application



#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	ファイル生成規則
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#*******************************************************************************
#	アプリケーション作成
#*******************************************************************************
$(APL_NAME): $(STARTUP) $(OBJECTS)
	@echo -e "\tld\t$@"
	ld -o $@ $^ $(LINK_OPTIONS)


#*******************************************************************************
#	スタートアップオブジェクト作成
#*******************************************************************************
$(STARTUP):
	make -C $(COMMON_DIR)Startup/ object



.PHONY: $(PHONY)
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
#	End of file
#■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■#
