/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Flag.cpp
	概要		：	フラグクラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"Flag.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	フラグクラス：静的パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	フラグセット
	説明	：
	Include	：	Flag.h
	引数	：	[u4 u4_Flags = 0]
	戻り値	：	void
*******************************************************************************/
void	Flag16::Init( u4 u4_Flags )
{
	Mu4_Flags = u4_Flags;
}


/*******************************************************************************
	概要	：	フラグ設定
	説明	：
	Include	：	Flag.h
	引数	：	u4 u4_Flags		変更するフラグ
	戻り値	：	void
*******************************************************************************/
void	Flag16::SetFlags( u4 u4_Flags )
{
	u4		u4_Mask = ( u4_Flags & 0xffff0000 ) | ( u4_Flags >> 16 );
	Mu4_Flags = ( Mu4_Flags & ~u4_Mask ) | ( u4_Flags & u4_Mask );
}


/*******************************************************************************
	概要	：	フラグ取得
	説明	：	引数で指定したフラグを取得します。
	Include	：	Flag.h
	引数	：	[u4 u4_Flags = 0xffffffff]		取得するフラグ(上位16ビットのマスクのみ有効)
	戻り値	：	u4		フラグ
*******************************************************************************/
u4		Flag16::GetFlags( u4 u4_Flags )
{
	u4		u4_Mask = ( u4_Flags & 0xffff0000 ) | ( u4_Flags >> 16 );
	return ( Mu4_Flags & u4_Mask );
}


/*******************************************************************************
	概要	：	フラグチェック
	説明	：
	Include	：	Flag.h
	引数	：	u4 u4_Flags
	戻り値	：	bool
*******************************************************************************/
bool	Flag16::CheckFlags( u4 u4_Flags )
{
	u4		u4_Mask = u4_Flags >> 16;
	return ( ( Mu4_Flags & u4_Mask ) == ( u4_Flags & u4_Mask ) );
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

