/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Flag.h
	概要		：	フラグクラス
	詳細		：	フラグを簡単に扱えるように工夫されたクラスです。
					32ビットのフラグのうち、上位16ビットはマスクとして使用します。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	16ビットフラグクラス
*******************************************************************************/
class	Flag16
{
//変数
private:
	u4		Mu4_Flags;

//メソッド
public:
	void	Init( u4 u4_Flags = 0 );				//初期化
	void	SetFlags( u4 u4_Flags );				//フラグ設定
	u4		GetFlags( u4 u4_Flags = 0xffffffff );	//フラグ取得
	bool	CheckFlags( u4 u4_Flags );				//フラグチェック
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

