/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Objects/Caption.cpp
	概要		：	Mul light API - キャプションクラス
	詳細		：	キャプションを持つシングルボックスです。
					抽象的なクラスで、これ自体にあまり意味はありません。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"Caption.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	キャプションクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	キャプションのポインタ設定
	説明	：
	Include	：	Caption.h
	引数	：	const char* CPc_Caption		キャプションのポインタ
	戻り値	：	void
*******************************************************************************/
void	Caption::SetCaption( const char* CPc_Caption ){ MCPc_Caption = CPc_Caption; }


/*******************************************************************************
	概要	：	キャプションのポインタ取得
	説明	：
	Include	：	Caption.h
	引数	：	void
	戻り値	：	const char*		キャプションのポインタ
*******************************************************************************/
const char*	Caption::GetCaption( void ){ return MCPc_Caption; }



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	キャプションクラス：プロテクティッドメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	キャプションクラスの初期化
	説明	：
	Include	：	Caption.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	Caption::Init( void )
{
	Single::Init();
	Object::SetObjectType( Object::CAPTION );

	MCPc_Caption	= NULL;		//キャプション
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

