/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/SC.cpp
	概要		：	Mul light API - システムコールクラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"SC.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
namespace
{
	enum
	{
		SC_SELECTOR		= 0x1b,		//システムコールのコールゲートのセレクタ
	};
}


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	システムコールクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	システムコール
	説明	：
	Include	：	SC.h
	引数	：	SCID SCID			システムコールID
				SCDBase* P_SCD		システムコールデータのポインタ
	戻り値	：	u4		システムコール戻り値
*******************************************************************************/
u4		SC::SystemCall( SCID SCID, SCDBase* P_SCD )
{
	u4		u4_RetValue;

	//システムコール実行
	__asm__
	(
			"pushl	%1;"
			"pushl	%2;"
			"lcall	%3,		$0x00;"
			: "=a"( u4_RetValue )
			: "r"( SCID ), "r"( P_SCD ), "i"( SC_SELECTOR )
			:
	);
	return u4_RetValue;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

