/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Stack.h
	概要		：	Mul light API - スタッククラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	基本スタッククラス
*******************************************************************************/
class	StackBase
{
//定数
public:
	//エラー情報
	enum	Error
	{
		ERROR = _ERROR_,
		ERROR_STACK_NULL,		//スタックにデータが入っていない。
		ERROR_STACK_FULL,		//スタックのデータが満杯になっている。

		SUCCESS = _SUCCESS_,
	};

//変数
protected:
	ui		Mui_Pointer;		//スタックポインタ

//メソッド
public:
	void	Init( void );

	//データ数取得
	u1		GetNumData( void );
};


/*******************************************************************************
	1バイトスタッククラス
*******************************************************************************/
class	Stack1 : public StackBase
{
private:
	u1		Mu1_Stack[256];			//スタック本体
public:
	s4		Push( u1 u1_Data );
	s4		Pop( u1* Pu1_Data );
	s4		Read( u1* Pu1_Data );
};


/*******************************************************************************
	2バイトスタッククラス
*******************************************************************************/
class	Stack2 : public StackBase
{
private:
	u2		Mu2_Stack[256];			//スタック本体
public:
	s4		Push( u2 u2_Data );
	s4		Pop( u2* Pu2_Data );
	s4		Read( u2* Pu2_Data );
};


/*******************************************************************************
	4バイトスタッククラス
*******************************************************************************/
class	Stack4 : public StackBase
{
private:
	u4		Mu4_Stack[256];			//スタック本体
public:
	s4		Push( u4 u4_Data );
	s4		Pop( u4* Pu4_Data );
	s4		Read( u4* Pu4_Data );
};


/*******************************************************************************
	8バイトスタッククラス
*******************************************************************************/
class	Stack8 : public StackBase
{
private:
	u8		Mu8_Stack[256];			//スタック本体
public:
	s4		Push( u8 u8_Data );
	s4		Pop( u8* Pu8_Data );
	s4		Read( u8* Pu8_Data );
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
