/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Boot/BootLoader/GetMemoryMap.S
	概要		：	メモリサイズを取得するサブルーチン
	詳細		：	BIOSコールでメモリサイズと、メモリマップを取得します。
					メモリマップ情報は0x0000 0600〜0x0000 05ffに格納します。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.global		_GetMemoryMap



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#メモリマップ情報のサイズ(Byte)
MAP_DATA_SIZE	= 0x18
						#24Byte

#メモリマップ情報バッファアドレス
_ES_			= ( PARAM_BASE + 0x100 ) >> 4
_DI_			= 0x0000

#シグネチャ
SMAP			= 0x534d4150

#許容サイズ
LIMIT_SIZE		= MAP_DATA_SIZE * 0x80
		#0x18 * 0x80 = 0xc00 = 3KiB

#ヘッダ情報アドレス
HEADER_NUM_MAP	= _DI_



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	テキストセクション
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.section .text
	.code16

/*******************************************************************************
	メモリマップ取得
*******************************************************************************/
_GetMemoryMap:
/*------------------------------------------------------------------------------
	初期化
------------------------------------------------------------------------------*/
	#データ格納先のメモリアドレス指定
	movw		$_ES_,				%ax
	movw		%ax,				%es
	movw		$_DI_,				%di

	xorl		%ebx,				%ebx	#初回のみ0

_E820Loop:
	movl		$0x0000e820,		%eax	#コール番号
	movl		$MAP_DATA_SIZE,		%ecx	#バッファサイズ
	movl		$SMAP,				%edx	#シグネチャ
	addw		$MAP_DATA_SIZE,		%di		#バッファアドレスを進める(先頭の24バイトはヘッダ情報を入れるのでこれでいい。)

	int			$0x15					#メモリチェック実行

	#エラー処理
	#-----------------------------------
	jc			_GetMemoryMapFailed		#キャリーエラー:if( CF == true ) jmp _GetMemoryMapFailed;

	cmpl		$SMAP,				%eax
	jne			_GetMemoryMapFailed		#シグネチャエラー:if( %eax != $SMAP ) jmp _GetMemoryMapFailed;

	cmpw		$LIMIT_SIZE,		%di
	ja			_GetMemoryMapFailed		#許容オーバーエラー:if( %di > LIMIT_SIZE ) jmp _GetMemoryMapFailed;
	#-----------------------------------

	orl			%ebx,				%ebx	#終了なら0になっている
	jnz			_E820Loop				#終了でないならもう一度。


	#マップデータ数を数え、メモリに保存
	xorw		%dx,				%dx
	movw		%di,				%ax		#di:メモリマップの総データ数
	movw		$MAP_DATA_SIZE,		%bx
	divw		%bx						#ax = dx:ax / bx … dx
	movw		%ax,				%es:( HEADER_NUM_MAP )

	#メモリチェック正常終了
_GetMemoryMapSuccess:
	xorl		%eax,				%eax
	ret


	#メモリチェック失敗。
_GetMemoryMapFailed:
	movl		$0xffffffff,		%eax
	ret



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

