/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Boot/BootLoader/Main.S
	概要		：	ブートローダのメインです。
	詳細		：	ブートローダのメインプログラムです。
					El Toritoによって、メモリの0x0007 0000〜0x0007 ffffに読み込まれます。
					メモリチェックとVBEの設定を行った後、プロテクトモードに移行し、CDからカーネルを読み込みます。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
ORIGIN			= 0x60000

#スタック
_SS_			= 0x4000
_SP_			= 0x0000
_ESP_			= 0x00050000

#セグメント
SEG_REG			= 0x6000
K_CS			= 0x0008			#カーネル用コード・セグメント
K_DS			= 0x0010			#カーネル用データ・セグメント
B_CS			= 0x0018			#ブートローダ用コード・セグメント(カーネル実行時には、このディスクリプタは削除する。)

#GDT/IDT
GDT_BASE		= 0x50000
GDT_LIMIT		= 0xffff
IDT_BASE		= 0x60000
IDT_LIMIT		= 0x07ff

#カーネル前半
K_FIRST_BUFFER	= 0x64000
K_FIRST_BASE	= 0x0000
K_FIRST_SIZE	= 0xc000


/*******************************************************************************
	I/Oポート
*******************************************************************************/
PORT_RTC		= 0x0070
PORT_A			= 0x0092


/*******************************************************************************
	コントロール・レジスタ
*******************************************************************************/
/*------------------------------------------------------------------------------
	CR0
------------------------------------------------------------------------------*/
#フラグ
CR0_PE			= 0x00000001		#プロテクト・イネーブル・フラグ




/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	実行コード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.section .text
	.code16
/*******************************************************************************
	初期化
*******************************************************************************/
	#セグメントレジスタの初期化
	movw		$SEG_REG,		%ax
	movw		%ax,			%ds
	movw		%ax,			%es
	movw		%ax,			%fs
	movw		%ax,			%gs

	#スタックを設定
	movw		$_SS_,			%ax
	movw		%ax,			%ss
	movw		$_SP_,			%sp


/*******************************************************************************
	プロテクトモード移行前の処理
	16bitのBIOSコールをする場合など。
*******************************************************************************/
	#A20ゲートの開放
	inb			$PORT_A,		%al
	orb			$0b00000010,	%al
	andb		$0b11111110,	%al
	outb		%al,			$PORT_A		#システムコントロールポート。

	#メモリマップとメモリサイズの取得
	call		_GetMemoryMap

	#グラフィックスの設定。VBEを使って高解像度！
	call		_SetGraphics


/*******************************************************************************
	プロテクトモード移行処理
*******************************************************************************/
	cli

	#NMIの割り込みを禁止する
	movb		$0b00001000,	%al
	outb		%al,			$PORT_RTC


/*------------------------------------------------------------------------------
	GDTRとIDTRの仮設定
------------------------------------------------------------------------------*/
	lgdt		_GDTR_TEMP
	lidt		_IDTR

/*------------------------------------------------------------------------------
	プロテクトモード移行
------------------------------------------------------------------------------*/
	movl		%cr0,			%eax
	orl			$CR0_PE,		%eax		#プロテクト・イネーブル・フラグ
	movl		%eax,			%cr0
	jmp			_PipelineFlush				#パイプラインを流れているデータを消す。
_PipelineFlush:


	#ここから32bitです。
	.code32
	.byte		0x66
	ljmp		$B_CS, $_SetCodeSegment		#far jmpでCSをセットする。(CSにDbit=1のGDTを読み込むことによって、32bitになる。)
_SetCodeSegment:

	#セグメントレジスタの再設定
	movw		$K_DS,			%ax
	movw		%ax,			%ds
	movw		%ax,			%es
	movw		%ax,			%fs
	movw		%ax,			%gs
	movw		%ax,			%ss

	#スタックの設定
	movl		$_ESP_,			%esp


/*******************************************************************************
	データ転送
	GDT、IDT、カーネルを転送します。
*******************************************************************************/
/*------------------------------------------------------------------------------
	カーネルの転送
------------------------------------------------------------------------------*/
	movl		$K_FIRST_SIZE >> 2,	%ecx	#転送回数。0xc000 / 4
	movl		$K_FIRST_BUFFER,	%esi	#転送元
	movl		$K_FIRST_BASE,		%edi	#転送先
	rep			movsl						#一回の転送で4Byte

/*------------------------------------------------------------------------------
	GDTの転送、GDTR・IDTRの設定
------------------------------------------------------------------------------*/
	#GDTの転送
	movl		$2 * 4,			%ecx		#転送回数。8Byte / 4 * ディスクリプタ数
	movl		$_GDT + ORIGIN,	%esi		#転送元
	movl		$GDT_BASE,		%edi		#転送先
	rep			movsl						#一回の転送で4Byte

	#GDTR・IDTRの設定
	lgdt		_GDTR + ORIGIN
	lidt		_IDTR + ORIGIN



/*******************************************************************************
	ブートローダの役目終了。スタックを設定して、カーネルへ入ります。
*******************************************************************************/
	#スタックの設定
	movl		$_ESP_,				%esp
	movl		%esp,				%ebp

	ljmp		$K_CS,				$K_FIRST_BASE



	#ラベルなしのhaltループ。コピペして使える。
	hlt
	.byte		0xeb, 0xfd

	#ラベルなしのループ。コピペして使える。
	.byte		0xeb, 0xfe



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	データ
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.section .data
/*******************************************************************************
	GDTR・GDT
*******************************************************************************/
/*------------------------------------------------------------------------------
	GDTR_TEMP
------------------------------------------------------------------------------*/
	.align		16

_GDTR_TEMP:
_GDTR_TEMP_Limit:
	.word		_GDT_END - _GDT - 1
_GDTR_TEMP_Base:
	.long		_GDT + ORIGIN


/*------------------------------------------------------------------------------
	GDTR
------------------------------------------------------------------------------*/
	.align		16

_GDTR:
_GDTR_Limit:
	.word		GDT_LIMIT
_GDTR_Base:
	.long		GDT_BASE


/*------------------------------------------------------------------------------
	GDT
------------------------------------------------------------------------------*/
	.align		16

_GDT:
_GDT_NULL:				#0x0000
	.word		0x0000
	.word		0x0000
	.byte		0x00
	.byte		0x00
	.byte		0x00
	.byte		0x00

_GDT_KernelCS:		#0x0008 Base:0x00000000, Limit:0xfffff(単位:Page), SegmentType:Code(Exe/Read)
	.word		0xffff
	.word		0x0000
	.byte		0x00
	.byte		0x9a
	.byte		0xcf
	.byte		0x00

_GDT_KernelDS:		#0x0010 Base:0x00000000, Limit:0xfffff(単位:Page), SegmentType:Data(Read/Write)
	.word		0xffff
	.word		0x0000
	.byte		0x00
	.byte		0x92
	.byte		0xcf
	.byte		0x00

_GDT_BootLoaderCS:	#0x0018 Base:0x00060000, Limit:0xfffff(単位:Page), SegmentType:Code(Exe/Read)
	.word		0xffff
	.word		0x0000
	.byte		0x06
	.byte		0x9a
	.byte		0xcf
	.byte		0x00


_GDT_END:



/*******************************************************************************
	IDTR
*******************************************************************************/
/*------------------------------------------------------------------------------
	IDTR
------------------------------------------------------------------------------*/
	.align		16

_IDTR:
_IDTR_Limit:
	.word		IDT_LIMIT
_IDTR_Base:
	.long		IDT_BASE




/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
