/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/DTM/LDT.h
	概要		：	ローカル・ディスクリプタ・テーブルヘッダ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"DTM/DT.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	LDTクラス
	本来、コード・データセグメントに加え、コールゲートを登録できますが、
	コールゲートは使用しません。汎用性を無視した作りにしてあります。
*******************************************************************************/
class	LDT : public DTBase
{
//定数
private:
	enum
	{
		USABLE_NUMBER	= 2,
		LDT_SIZE		= 16,
	};

//変数
private:
	SegmDesc	MA_LDT[16];			//ローカル・ディスクリプタ・テーブル本体

//メソッド
public:
	void	Init( void );

	//ディスクリプタの登録
	//セグメント・ディスクリプタ
	s4		SetSegment( SegmInfo SegmInfo, SELECTOR* P_Selector = NULL );				//番号自動設定
	s4		SetSegment( ui ui_Number, SegmInfo SegmInfo, SELECTOR* P_Selector = NULL );	//番号手動指定

	//ディスクリプタ情報取得
	SegmInfo	GetSegmInfo( SELECTOR Selector );		//セグメント情報取得

	//ディスクリプタの削除
	s4		ClearDescriptor( SELECTOR Selector );
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
