/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/FS/FS.h
	概要		：	FS(ファイルシステム)
	詳細		：	ファイルシステムのベースクラスです。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	ファイル・システム・タイプ
*******************************************************************************/
namespace	FST
{
	enum	FSType
	{
		NON,

		ISO9660,
		JOLIET,
		ROCKRIDGE,

		KEYBOARD,
		MOUSE,
	};
}


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	FSクラス
	ファイルシステムのベースクラス
*******************************************************************************/
class	FS
{
//変数
protected:
	ui		Mui_FSMemID;		//ファイルシステムクラスのメモリ領域ID
	FST::FSType	M_FSType;		//ファイルシステムの種類

//メソッド
public:
	ui		GetMemID( void );			//ファイルシステムクラスのメモリ領域ID取得
	FST::FSType	GetFSType( void );		//ファイルシステムの種類取得
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
