/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/FS/ISO9660/Define.h
	概要		：	ISO9660(ファイルシステム)
	詳細		：	ISO9660(ファイルシステム)の各種定義です。
	責任者		：
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	単位変換
*******************************************************************************/
#define	BYTE2SECTOR( _BYTE_ )		( ( _BYTE_ ) >> 11 )				//バイト -> セクタ
#define	BYTE2SECTOR_CEIL( _BYTE_ )	( ( ( _BYTE_ ) + 0x7ff ) >> 11 )	//バイト -> セクタ(切り上げ)
#define	SECTOR2BYTE( _SECTOR_ )		( ( _SECTOR_ ) << 11 )				//セクタ -> バイト



/*******************************************************************************
	ボリューム・ディスクリプタのオフセット値
*******************************************************************************/
enum	VDOffset
{
	VD_PT_SIZE		= 0x0084,		//パステーブルサイズ(単位:バイト, サイズ:4)
	VD_PT_SIZE_B	= 0x0088,		//パステーブルサイズ(単位:バイト, サイズ:4)
	VD_PT_LBA		= 0x008c,		//パステーブルの先頭LBA(サイズ:4)
};


/*******************************************************************************
	パステーブル・レコードのオフセット値
*******************************************************************************/
enum	PTROffset
{
	PTR_NAME_LEN		= 0x00,		//ディレクトリ名の長さ(単位:バイト, サイズ:1)
	PTR_EXT_ATTR_LEN	= 0x01,		//拡張属性レコード(サイズ:1)
	PTR_DIR_LBA			= 0x02,		//ディレクトリのLBA(単位:セクタ, サイズ:4)
	PTR_PARENT			= 0x06,		//親ディレクトリ番号(サイズ:2)
	PTR_NAME			= 0x08,		//ディレクトリ名
};


/*******************************************************************************
	ディレクトリ・レコード
*******************************************************************************/
//ファイル属性フラグ
enum	DRFlags
{
	B0_VISIBLE		= 0x00,
	B0_INVISIBLE	= 0x01,
	B1_FILE			= 0x00,
	B1_DIR			= 0x02,
	B2_MAIN			= 0x00,
	B2_ASSOCIATED	= 0x04,
	B3_NON_RECOR	= 0x00,
	B3_RECOR		= 0x08,
	B4_PRT_DISABLE	= 0x00,
	B4_PRT_ENABLE	= 0x10,
	B7_END_OF_DR	= 0x00,
	B7_MULTI_EXTENT	= 0x80,
};
enum	DRFlagMask
{
	B0_VISIBLE_MASK			= 0x01,
	B1_DIR_MASK				= 0x02,
	B2_ASSOCIATED_MASK		= 0x04,
	B3_RECORD_MASK			= 0x08,
	B4_PROTECTION_MASK		= 0x10,
	B7_MULTI_EXTENT_MASK	= 0x80,
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	日時構造体(長)
*******************************************************************************/
struct	DateTimeLong
{
	u4		u4_Year;		//年(文字列)
	u2		u2_Month;		//月(文字列)
	u2		u2_Day;			//日(文字列)
	u2		u2_Hour;		//時(文字列)
	u2		u2_Minute;		//分(文字列)
	u2		u2_Second;		//秒(文字列)
	u2		u2_MilliSec;	//ミリ秒(文字列)
	u1		u1_DifUTC;		//UTCとの偏差
}__attribute__((packed));


/*******************************************************************************
	日時構造体(短)
*******************************************************************************/
struct	DateTimeShort
{
	u1		u1_Year;		//1900年からの年(1900～2155)
	u1		u1_Month;		//月
	u1		u1_Day;			//日
	u1		u1_Hour;		//時
	u1		u1_Minute;		//分
	u1		u1_Second;		//秒
	u1		u1_DifUTC;		//UTCとの偏差
};


/*******************************************************************************
	ディレクトリ・レコード
*******************************************************************************/
struct	DR
{
	u1		u1_Length;			//ディレクトリ・レコード自体の長さ
	u1		u1_ExtAttrLen;		//拡張属性レコードの長さ
	u4		u4_LBA;				//ディレクトリ／ファイルのLBA
	u4		u4_LBA_B;
	u4		u4_Size;			//ディレクトリ／ファイルのサイズ(単位:バイト)
	u4		u4_SizeB;
	DateTimeShort	Date;		//記録日時
	u1		u1_AttrFlags;		//ファイル属性フラグ
	u1		u1_FileUnitSize;	//ファイルユニットの大きさ？
	u1		u1_Interleave;		//インターリーブ間隙？
	u2		u2_VolumeNo;		//ボリューム番号？
	u2		u2_VolumeNoB;
	u1		u1_NameLen;			//ディレクトリ／ファイル名の長さ
	char	Ac_Name[1];			//ディレクトリ／ファイル名
}__attribute__((packed));


/*******************************************************************************
	ボリューム・ディスクリプタ
*******************************************************************************/
struct	VD
{
	u1		u1_Type;						//ボリューム記述子タイプ
	char	Ac_ID[5];						//識別子"CD001"
	u1		u1_Version;						//ボリューム記述子バージョン
	u1		u1_Flags;						//フラグ
	char	Ac_SystemID[0x20];				//システム識別子
	char	Ac_VolumeID[0x20];				//ボリューム識別子
	u1		Au1_Reserved048[8];
	u4		u4_NumBlock;					//総ブロック数
	u4		u4_NumBlockB;
	char	Ac_EscapeSequences[0x20];		//エスケープシーケンス
	u2		u2_NumVolume;					//総ボリューム数
	u2		u2_NumVolumeB;
	u2		u2_VolumeNo;					//ボリューム番号
	u2		u2_VolumeNoB;
	u2		u2_LBSize;						//論理ブロックのサイズ(単位:バイト)
	u2		u2_LBSizeB;
	u4		u4_PTSize;						//パステーブルのサイズ(単位:バイト)
	u4		u4_PTSizeB;
	u4		u4_PT_LBA;						//パステーブルのLBA
	u4		u4_OptPT_LBA;					//パステーブルのLBA(オプション)
	u4		u4_PT_LBA_B;
	u4		u4_OptPT_LBA_B;
	DR		RootDR;							//ルート・ディレクトリ・レコード
	char	Ac_VolumeSetID[0x80];			//ボリュームセット名
	char	Ac_PublisherID[0x80];			//出版者
	char	Ac_PreparerID[0x80];				//編集者
	char	Ac_ApplicationID[0x80];			//応用システム識別子
	char	Ac_CopylightFileID[0x25];		//著作権ファイル識別子
	char	Ac_AbstractFileID[0x25];			//抄録ファイル識別子
	char	Ac_BibliographicFileID[0x25];	//書誌ファイル識別子
	DateTimeLong	CreationDate;			//ボリューム作成日時
	DateTimeLong	ModificationDate;		//ボリューム更新日時
	DateTimeLong	ExpirationDate;			//ボリューム失効日時
	DateTimeLong	EffectiveDate;			//ボリューム発効日時
	u2		u2_FileStructureVersion;		//ファイル構造バージョン
	u1		u1_Reserved373;
	u1		Au1_AppliUse[0x200];				//アプリケーション使用
	u1		Au1_Reserved574[0x28c];
}__attribute__((packed));


/*******************************************************************************
	パステーブル・レコード
*******************************************************************************/
struct	PTR
{
	u1		u1_NameLen;			//ディレクトリ名の長さ(単位:バイト)
	u1		u1_ExtAttrLen;		//拡張属性レコード
	u4		u4_DirLBA;			//ディレクトリのLBA
	u2		u2_Parent;			//親ディレクトリ番号
	char	Ac_Name[2];			//ディレクトリ名(最小=1文字+パディング)
}__attribute__((packed));



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
