/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/FS/Joliet/Joliet.h
	概要		：	Joliet(ファイルシステム)
	詳細		：
	責任者		：
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"ISO9660/ISO9660.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	パスデータ
*******************************************************************************/
struct	Joliet_PathData
{
	char	c_DirName[128];	//ディレクトリ名(UCS-2)
	u4		u4_LBA;			//ディレクトリ情報のLBA
	u2		u2_Parent;		//親ディレクトリ番号
	u1		u1_Padding[2];
};


/*******************************************************************************
	ディレクトリ情報
*******************************************************************************/
struct	Joliet_DirInfo
{
};


/*******************************************************************************
	Jolietクラス
*******************************************************************************/
class	Joliet : public ISO9660
{
//定数
public:
	//エラー情報
	enum	Error
	{
		ERROR = _ERROR_,
		ERROR_NOTSUPPORT,		//サポート対象外

		SUCCESS = _SUCCESS_,
	};

//変数
private:

//メソッド
public:
	void	Init( void );

	s4		CheckFS( u1 u1_DeviceID );		//ファイルシステム確認

//	s4		Rename( const char* CPc_FilePath, const char* CPc_NewFileName );				//ファイル名変更
	s4		Read( const char* CPc_FilePath, ui ui_Offset, u1* Pu1_Addr, ui ui_Size );		//読み取り
//	s4		Write( const char* CPc_FilePath, ui ui_Offset, u1* Pu1_Addr, ui ui_Size );		//書き込み
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
