/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/IM/IM.h
	概要		：	割り込み管理ヘッダ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*******************************************************************************
//割り込みルーチンテンプレート。**が16進数の番号00～FF
//通常の割り込みルーチン用。レジスタの書き換え防止
void	Int**( ARG_CONST_REGI_STAT )
{
}

//例外割り込み等用。例外割り込みなどで、レジスタの値を書き換える必要がある場合
void	Int**( ARG_REGI_STAT )
{
}
*******************************************************************************/


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	割り込みルーチン用レジスタ状態引数
	通常の割り込みでは、レジスタの状態を書き換えてはいけない。
*******************************************************************************/
//書き換え不可引数
#define	ARG_CONST_REGI_STAT	const u2 Cu2_ES, const u2 Cu2_DS,\
							const u4 Cu4_EDI, const u4 Cu4_ESI, const u4 Cu4_EBP, const u4 Cu4_ESP,\
							const u4 Cu4_EBX, const u4 Cu4_EDX, const u4 Cu4_ECX, const u4 Cu4_EAX,\
							const u4 Cu4_EIP, const u2 Cu2_CS, const u4 Cu4_EFlags

//書き換え可能引数
#define	ARG_REGI_STAT	u2 u2_ES, u2 u2_DS,\
						u4 u4_EDI, u4 u4_ESI, u4 u4_EBP, u4 u4_ESP, u4 u4_EBX, u4 u4_EDX, u4 u4_ECX, u4 u4_EAX,\
						u4 u4_EIP, u2 u2_CS, u4 u4_EFlags



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	割り込み管理クラス
*******************************************************************************/
class	IM
{
public:
	void	Init( void );
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
