/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/KLib/KStdLib.cpp
	概要		：	カーネル専用標準ライブラリ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"
#include	"KStdLib.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	入力
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	カーネルアドレスからローカルアドレスへ変換
	説明	：	ローカルのベースアドレスを元に
				カーネルのアドレスをローカルのアドレスに変換します。
	Include	：	IO.h
	引数	：	const void* CPv_K2LAddr		カーネルアドレスのアドレス
				const void* CPv_LocalAddr	ローカルのベースアドレス
	戻り値	：	void*		変換後のアドレス(ローカルアドレス)
*******************************************************************************/
void*	KStdLib::ConvK2L( const void* CPv_K2LAddr, const void* CPv_LocalAddr )
{
	return (void*)( (ui)CPv_K2LAddr - (ui)CPv_LocalAddr );
}

/*******************************************************************************
	概要	：	ローカルアドレスからカーネルアドレスへ変換
	説明	：	ローカルのベースアドレスを元に
				ローカルのアドレスをカーネルのアドレスに変換します。
	Include	：	IO.h
	引数	：	const void* CPv_L2KAddr		ローカルアドレスのアドレス
				const void* CPv_LocalAddr	ローカルのベースアドレス
	戻り値	：	void*		変換後のアドレス(カーネルアドレス)
*******************************************************************************/
void*	KStdLib::ConvL2K( const void* CPv_L2KAddr, const void* CPv_LocalAddr )
{
	return (void*)( (ui)CPv_L2KAddr + (ui)CPv_LocalAddr );
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

