/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/MM/KMA.cpp
	概要		：	カーネル用のメモリ割り当て
	詳細		：	Kernel Memory Allocation
					カーネル用のヒープ領域のメモリ割り当てをします。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"
#include	"KMA.h"
#include	<Math.h>



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
namespace
{
	enum
	{
		KHEAP_BASE		= 0x700000,		//ヒープ領域ベースアドレス
		KHEAP_SIZE		= 0x38000,		//ヒープ領域サイズ
	};
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	KMAクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	KMAクラスの初期化
	説明	：	最初のメモリマップを作成します。
	Include	：	KMA.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	KMA::Init( void )
{
	//ヒープ領域クリア
	__asm__
	(
			"xorl	%%eax,		%%eax;"
			"rep	stosl;"
			:
			: "D"( KHEAP_BASE ), "c"( KHEAP_SIZE >> 2 )
			: "%eax"
	);

	M_LM.Init( &M_MAL[0] );

	M_MAL[0].Mu4_Base	= KHEAP_BASE;
	M_MAL[0].Mu4_Size	= KHEAP_SIZE;
	M_MAL[0].M_Flag16.Init( MAL::USAGE_FREE );

	DP( "KMA::Init()\t\t\t\t\t\t\t\t\t[  OK  ]" );
}


/*******************************************************************************
	概要	：	メモリ領域確保
	説明	：	指定のサイズの空き領域を検索して、ベースアドレスを返します。
				引数のサイズは4バイト単位に切り上げられます。
	Include	：	KMA.h
	引数	：	ui ui_ByteSize		取得するメモリのサイズ(Byte単位)
	戻り値	：	ui		確保したメモリ領域のID((ui)-1ならエラー)
*******************************************************************************/
ui		KMA::Create( ui ui_ByteSize )
{
	return MA::Create( INT_CEIL_BIN( ui_ByteSize, 4 - 1 ) );
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

