/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/Main.cpp
	概要		：	カーネルのメインです。
	詳細		：	カーネルのメインプログラムです。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"

#include	"SCM.h"
#include	"RDTM.h"
#include	"VFS.h"
#include	"APM.h"
#include	"WM.h"

#include	"Main.h"

#include	"Stack.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	スーパーグローバル
	Common.hをインクルードするだけで利用できる
*******************************************************************************/
GMA		G_GMA;		//全域メモリ割り当て
KMA		G_KMA;		//カーネル用メモリ割り当て
GDT		G_GDT;		//グローバル・ディスクリプタ・テーブル
IDT		G_IDT;		//割り込み・ディスクリプタ・テーブル
GUI		G_GUI;		//グラフィカル・ユーザ・インターフェース

ui		Gui_DebugY = 0;

/*******************************************************************************
	通常グローバル
*******************************************************************************/
DM		G_DM;
TM		G_TM;
SCM		G_SCM;
RDTM	G_RDTM;
APM		G_APM;
WM		G_WM;
VFS		G_VFS;

//タスク
extern Task*	GP_APMTask;			//アプリケーション管理タスク
extern Task*	GP_WMTask;			//ウィンドウ管理タスク
extern Task*	GP_GDDMTask;		//グローバル・デバイス・データ管理タスク
extern Task*	GP_DesktopTask;		//デスクトップタスク


bool	Gb_InitFinishFlag = false;



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	メインクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	メインクラスのコンストラクタです。
	説明	：
	Include	：	Main.h
	引数	：	void
	戻り値	：	-
*******************************************************************************/
Main::Main( void )
{
	//メモリ0クリア(ブートローダなどがあった場所。IDTが0x800バイト使う。)
	__asm__
	(
			"xorl	%%eax,		%%eax;"
			"rep	stosl;"
			:
			: "D"( 0x60000 ), "c"( 0x10000 >> 2 )
			: "%eax"
	);
}



/*******************************************************************************
	概要	：	メインクラスの初期化プログラムです。
	説明	：	ブート・パラメータの取得やハードウェアの初期化などを行います。
	Include	：	Main.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	Main::Init( void )
{
	//各クラス初期化
	{
		G_GUI.Init();		//GUI初期化(デバッグ確認のため、真っ先に初期化する。)
		//----------------------------------------------------------
		G_KMA.Init();		//カーネル用メモリ割り当て初期化
		G_GMA.Init();		//全域メモリ割り当て初期化
		//----------------------------------------------------------
		G_GDT.Init();		//GDT初期化
		G_IDT.Init();		//IDT初期化
		//----------------------------------------------------------
		M_IM.Init();		//割り込み初期化
		G_TM.Init();		//タスク管理初期化
		G_SCM.Init();		//システムコール初期化
		//----------------------------------------------------------
		G_DM.SysInit();		//デバイス管理初期化
		G_RDTM.Init();		//実日時管理初期化
		G_VFS.Init();		//ファイルシステム初期化
		//----------------------------------------------------------
		__asm__( "sti;" );
		G_DM.Init();		//デバイス管理初期化
//		G_APM.Init();		//アプリケーション管理初期化
		G_GUI.Init2();		//GUIの初期化2
		__asm__( "cli;" );
	}




	// 2011/02/28 21:05 更新。gitテスト用。
	// 2011/02/28 21:08





	//タスク追加
	{
		G_TM.AddTask( GP_APMTask );			//アプリケーション管理タスク
		G_TM.AddTask( GP_WMTask );			//ウィンドウ管理タスク
		G_TM.AddTask( GP_GDDMTask );		//グローバル・デバイス・データ管理タスク

		G_TM.AddTask( GP_DesktopTask );		//デスクトップタスク
	}

	Gb_InitFinishFlag = true;








	/*★☆割り込み許可☆★*/
	__asm__( "sti;" );
	//ここ以降、このタスクは、システム・アイドル・タスクとなり、タスク管理の制御下になる。


	//メイン初期化は終了。システム・アイドル・タスクに変化する。
	//	(メモリが勿体なかったから、一緒にした。)
	DP( "Main Init Finished. I change into \"System idle task\". " );

	while( true )
		__asm__( "hlt;" );
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
