/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/SC/SCEntry.S
	概要		：	システムコール・エントリ
	詳細		：	システムコールの入り口です。c++の関数を呼び出します。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#define	SC_NUM_ARG	( 2 )


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	関数
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	システムコールエントリ
	説明	：	システムコールの入り口です。
				DSとESを退避して、特権0のSSと同じにしたあと、ハンドラを呼び出します。
	Include	：
	引数	：	SC::SCID SCID		システムコールID
				SCDBase* P_SCD		システムコールデータ
	戻り値	：	u4		戻り値
*******************************************************************************/
	.global	_Z7SCEntryN2SC4SCIDEP7SCDBase
	.extern	_ZN3SCM9SCHandlerEN2SC4SCIDEP7SCDBase
_Z7SCEntryN2SC4SCIDEP7SCDBase:
	pushl	%ds
	pushl	%es
	movw	%ss,	%ax
	movw	%ax,	%ds
	movw	%ax,	%es

	#スタックフレーム作成
	pushl	%ebp
	movl	%esp,	%ebp

	pushl	20(%ebp)			#システムコールデータポインタ
	pushl	24(%ebp)			#システムコールID
	call	_ZN3SCM9SCHandlerEN2SC4SCIDEP7SCDBase

	#スタックフレーム開放
	leave

	popl	%es
	popl	%ds
	lret	$SC_NUM_ARG * 4



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

