/*
 * template.h
 *
 *  Created on: 2010/10/18
 *      Author: hide
 */

#ifndef TEMPLATE_H_
#define TEMPLATE_H_


template <class T>
class Stack
{
public:
	enum{ STACK_SIZE = 100 };  // スタックサイズ

	void Init();

	void push(const T& data);  // プッシュ
	T pop();                   // ポップ

private:
	T m_data[STACK_SIZE];      // スタック本体
	int m_sp;                  // スタックポインタ
};


// 初期化
template<class T> void Stack<T>::Init(){
	m_sp = 0;
}

// プッシュ
template<class T> void Stack<T>::push(const T& data){
	if( m_sp >= STACK_SIZE )  // スタックが満杯
	{
//		std::cout << "スタックが満杯でプッシュできません" << std::endl;
		return;
	}
	m_data[m_sp++] = data;
//	std::cout << data << "がプッシュされました" << std::endl;
}

// ポップ
template<class T> T Stack<T>::pop(void){
	if( m_sp <= 0 )  // スタックが空
	{
//		std::cout << "スタックが空でポップできません" << std::endl;
		return 0;
	}
	T data = m_data[--m_sp];
//	std::cout << data << "がポップされました" << std::endl;
	return data;
}


#endif /* TEMPLATE_H_ */
