/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	デバイス名	：	/Include/Mul_light/Device/DT.h
	概要		：	Mul light API - デバイス・タイプ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	デバイス・タイプ定義
*******************************************************************************/
namespace	DT
{
	//デバイス・タイプ・マスク
	enum	DevTypeMask
	{
		CLASS_MASK		= 0xff000000,
		TYPE_MASK		= 0x00ffffff,
	};

	//デバイスタイプ
	enum	DevType
	{
		//●ヒューマン・インターフェース・デバイス●
		//----------------------------------------------------------
		CLASS_HID		= 0x01000000,
		KEYBOARD,						//キーボード
		MOUSE,							//マウス

		HID_OTHER						= CLASS_HID | TYPE_MASK,
		//----------------------------------------------------------


		//●ストレージ●
		//----------------------------------------------------------
		CLASS_STRAGE,
		HDD,							//HDD
		CDD,							//CDD
		FDD,							//FDD
		REMOVABLE_MEMORY,				//USBメモリ、SDカード、メモリースティック etc...

		STRAGE_OTHER					= CLASS_STRAGE | TYPE_MASK,
		//----------------------------------------------------------


		//●ネットワーク●
		//----------------------------------------------------------
		CLASS_NETWORK,
		ETHERNET,						//イーサネット

		NETWORK_OTHER					= CLASS_NETWORK | TYPE_MASK,
		//----------------------------------------------------------


		//●オーディオ●
		//----------------------------------------------------------
		CLASS_AUDIO,

		AUDIO_OTHER						= CLASS_AUDIO | TYPE_MASK,
		//----------------------------------------------------------


		//●プリンタ●
		//----------------------------------------------------------
		CLASS_PRINTER,

		PRINTER_OTHER					= CLASS_PRINTER | TYPE_MASK,
		//----------------------------------------------------------


		//●システムデバイス●
		//----------------------------------------------------------
		CLASS_SYSDEV,
		PIC_8259,						//割り込みコントローラ
		PIT_8254,						//インターバル・タイマー
		RTC,							//リアル・タイム・クロック
		PCI_BUS,						//PCIバス

		SYSDEV_OTHER					= CLASS_SYSDEV | TYPE_MASK,
		//----------------------------------------------------------


		//●ブリッジ●
		//----------------------------------------------------------
		CLASS_BRIDGE,
		HOST_BRIDGE,					//ホストブリッジ
		ISA_BRIDGE,						//ISブリッジ
		PCI_PCI_BRIDGE,					//PCI-PCIブリッジ

		BRIDGE_OTHER					= CLASS_BRIDGE | TYPE_MASK,
		//----------------------------------------------------------


		//●ストレージコントローラ●
		//----------------------------------------------------------
		CLASS_STRG_CONTROLLER,
		BUSMASTER_IDE,					//バスマスタIDE

		STRG_CONTROLLER_OTHER			= CLASS_STRG_CONTROLLER | TYPE_MASK,
		//----------------------------------------------------------


		//●シリアルバスコントローラ●
		//----------------------------------------------------------
		CLASS_SB_CONTROLLER,
		UHCI_USB,						//UHCI仕様USBホストコントローラ
		OHCI_USB,						//OHCI仕様USBホストコントローラ
		EHCI_USB,						//EHCI仕様USBホストコントローラ

		SB_CONTROLER_OTHER				= CLASS_SB_CONTROLLER | TYPE_MASK,
		//----------------------------------------------------------


		//その他
		CLASS_OTHER		= 0xff000000,
	};
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
