/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	デバイス名	：	Device.cpp
	概要		：	Mul light API - デバイスクラス
	詳細		：	一時凍結。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	デバイスクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	デバイスクラスのコンストラクタ
	説明	：
	Include	：	Device.h
	引数	：	void
	戻り値	：	-
*******************************************************************************/
Device::Device( void )
{
}

/*******************************************************************************
	概要	：	デバイスクラスのデストラクタ
	説明	：
	Include	：	Device.h
	引数	：	-
	戻り値	：	-
*******************************************************************************/
Device::~Device()
{
}


/*******************************************************************************
	概要	：	デバイスの存在確認
	説明	：	デバイスの存在確認のシステムコールを発行します。
	Include	：	Device.h
	引数	：	const char* CPc_DevicePath		対象のデバイスパス
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Device::PresentCheck( const char* CPc_DevicePath )
{
	s4		s4_RetValue;

	//デバイス存在確認
	__asm__
	(
			"pushl	%1;"
			"pushl	%2;"
			"lcall	%3,		$0x00;"
			: "=a"( s4_RetValue )
			: "i"( SC1::Device_PRESENTCHECK ), "r"( CPc_DevicePath ), "i"( SC_1 )
			:
	);
	return s4_RetValue;
}


/*******************************************************************************
	概要	：	デバイス読み込み
	説明	：	指定したサイズのデータをデバイスから読み込みます
	Include	：	Device.h
	引数	：	void* Pv_Addr				読み込んだデータを格納するアドレス
				u2 u2_Size					読み込むサイズ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Device::Read( void* Pv_Addr, u2 u2_Size )
{
	s4		s4_RetValue;

	//デバイス存在確認
	__asm__
	(
			"pushl	%1;"
			"pushl	%2;"
			"pushl	%3;"
			"pushl	%4;"
			"pushl	%5;"
			"lcall	%6,		$0x00;"
			: "=a"( s4_RetValue )
			: "i"( SC4::Device_READ ), "r"( Mc_DevicePath ), "r"( Mu4_DevicePointer ), "r"( Pv_Addr ), "r"( u2_Size ), "i"( SC_4 )
			:
	);
	return s4_RetValue;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of Device
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

