/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	デバイス名	：	Device.h
	概要		：	Mul light API - デバイスヘッダ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*
//デバイスの種類
namespace	DT
{
	enum
	{
		NON = 0,
		CLASS_MASK		= 0xff000000,
		TYPE_MASK		= 0x00ffffff,
	};

	enum	DevType
	{
		//●ヒューマン・インターフェース・デバイス●
		//----------------------------------------------------------
		CLASS_HID		= 0x01000000,
		KEYBOARD,						//キーボード
		MOUSE,							//マウス

		HID_OTHER						= CLASS_HID | TYPE_MASK,
		//----------------------------------------------------------


		//●ストレージ●
		//----------------------------------------------------------
		CLASS_STRAGE,
		HDD,							//HDD
		CDD,							//CDD
		FDD,							//FDD
		REMOVABLE_MEMORY,				//USBメモリ、SDカード、メモリースティック etc...

		STRAGE_OTHER					= CLASS_STRAGE | TYPE_MASK,
		//----------------------------------------------------------


		//●ネットワーク●
		//----------------------------------------------------------
		CLASS_NETWORK,
		ETHERNET,						//イーサネット

		NETWORK_OTHER					= CLASS_NETWORK | TYPE_MASK,
		//----------------------------------------------------------


		//●オーディオ●
		//----------------------------------------------------------
		CLASS_AUDIO,

		AUDIO_OTHER						= CLASS_AUDIO | TYPE_MASK,
		//----------------------------------------------------------


		//●プリンタ●
		//----------------------------------------------------------
		CLASS_PRINTER,

		PRINTER_OTHER					= CLASS_PRINTER | TYPE_MASK,
		//----------------------------------------------------------


		//●システムデバイス●
		//----------------------------------------------------------
		CLASS_SYSDEV,
		PIC_8259,						//割り込みコントローラ
		PIT_8254,						//インターバル・タイマー
		RTC,							//リアル・タイム・クロック
		PCI_BUS,						//PCIバス

		SYSDEV_OTHER					= CLASS_SYSDEV | TYPE_MASK,
		//----------------------------------------------------------


		//●ブリッジ●
		//----------------------------------------------------------
		CLASS_BRIDGE,
		HOST_BRIDGE,					//ホストブリッジ
		ISA_BRIDGE,						//ISブリッジ
		PCI_PCI_BRIDGE,					//PCI-PCIブリッジ

		BRIDGE_OTHER					= CLASS_BRIDGE | TYPE_MASK,
		//----------------------------------------------------------


		//●ストレージコントローラ●
		//----------------------------------------------------------
		CLASS_STRG_CONTROLLER,
		BUSMASTER_IDE,					//バスマスタIDE

		STRG_CONTROLLER_OTHER			= CLASS_STRG_CONTROLLER | TYPE_MASK,
		//----------------------------------------------------------


		//●シリアルバスコントローラ●
		//----------------------------------------------------------
		CLASS_SB_CONTROLLER,
		UHCI_USB,						//UHCI仕様USBホストコントローラ
		OHCI_USB,						//OHCI仕様USBホストコントローラ
		EHCI_USB,						//EHCI仕様USBホストコントローラ

		SB_CONTROLER_OTHER				= CLASS_SB_CONTROLLER | TYPE_MASK,
		//----------------------------------------------------------


		//その他
		CLASS_OTHER		= 0xff000000,
	};
}


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	デバイスクラス
*******************************************************************************
class	Device
{
//定数
public:
	//エラー情報
	enum	Error
	{
		ERROR = _ERROR_,

		SUCCESS = _SUCCESS_,
	};

//変数
private:
	u1		Mu1_DeviceID;		//デバイスID

//メソッド
public:
	Device( void );
	~Device();

	s4		SetDeviceID( u1 u1_DeviceID );	//デバイスIDをセット
	s4		PresentCheck( void );			//デバイスの存在確認
	s4		GetType( void );				//デバイスタイプ取得
	s4		Read( void );					//デバイス読み取り
};*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
