/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/MLStdLib.h
	概要		：	Mul light API - Mul light標準ライブラリクラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"SC.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	Mul light標準ライブラリクラス
*******************************************************************************/
class	MLStdLib
{
//定数
public:
	enum
	{
		_ERROR_,

		_SUCCESS_,
	};

//メソッド
public:
	static void	GetResolution( ui* Pui_ResX, ui* Pui_ResY );		//解像度取得
	static void	Sleep( ui ui_MSec = 0 );		//タスクスリープ(時間指定可)
	static void	Wakeup( ui ui_AppliID );		//タスク起動
	static void	FullDrawUpdate( void );			//全再描画

	static ui	CPLCheck( void );
};


/*******************************************************************************
	(SCD)解像度取得
*******************************************************************************/
namespace	SCD
{
	class	GetResolution : public SCDBase
	{
	public:
		ui		Mui_ResX;
		ui		Mui_ResY;
	};
}


/*******************************************************************************
	(SCD)タスクスリープ
*******************************************************************************/
namespace	SCD
{
	class	Sleep : public SCDBase
	{
	public:
		ui		Mui_MSec;
	};
}


/*******************************************************************************
	(SCD)タスク起動
*******************************************************************************/
namespace	SCD
{
	class	Wakeup : public SCDBase
	{
	public:
		ui		Mui_AppliID;
	};
}


/*******************************************************************************
	(SCD)全再描画
*******************************************************************************/
namespace	SCD
{
	class	FullDrawUpdate : public SCDBase
	{
	};
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
