/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Objects/Window.cpp
	概要		：	Mul light API - ウィンドウクラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"

#include	"Window.h"
#include	"Text.h"

#include	"MLStdLib.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ウィンドウクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	メッセージ送信
	説明	：	メッセージを送信します。
				何か追加メッセージが発生する場合は、ここで追加します。
	Include	：	Window.h
	引数	：	const Msg& CR_Message		送信するメッセージ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Window::SendMessage( const Msg& CR_Message )
{
//	Msg		Message;

	//エラー処理


	M_MsgQ.Enqueue( CR_Message );		//メッセージエンキュー

	//メッセージ追加
	switch( CR_Message.M_Message )
	{
	default:
		break;
	}

	MLStdLib::Wakeup( Mui_AppliID );

	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

