/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Queue.cpp
	概要		：	Mul light API - キュークラス
	詳細		：	FIFOでデータの出し入れをするデータ領域です。
					256の配列のリングバッファです。1,2,4,8バイトのキューがあります。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"Queue.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	基本キュークラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	基本キュークラスの初期化
	説明	：
	Include	：	Queue.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	QueueBase::Init( void )
{
	Mu1_Read = Mu1_Write = 0;
}


/*******************************************************************************
	概要	：	データ数の取得
	説明	：
	Include	：	Queue.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
u1		QueueBase::GetNumData( void )
{
	return Mu1_Write - Mu1_Read;
}


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	1バイトキュークラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	エンキュー
	説明	：	キューにデータを格納し、書き込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u1 u1_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue1::Enqueue( u1 u1_Data )
{
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	Mu1_Queue[Mu1_Write++] = u1_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u1* Pu1_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue1::Dequeue( u1* Pu1_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu1_Data = Mu1_Queue[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Queue.h
	引数	：	u1* Pu1_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue1::Read( u1* Pu1_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu1_Data = Mu1_Queue[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	2バイトキュークラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	エンキュー
	説明	：	キューにデータを格納し、書き込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u2 u2_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue2::Enqueue( u2 u2_Data )
{
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	Mu2_Queue[Mu1_Write++] = u2_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u2* Pu2_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue2::Dequeue( u2* Pu2_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu2_Data = Mu2_Queue[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Queue.h
	引数	：	u2* Pu2_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue2::Read( u2* Pu2_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu2_Data = Mu2_Queue[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	4バイトキュークラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	エンキュー
	説明	：	キューにデータを格納し、書き込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u4 u4_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue4::Enqueue( u4 u4_Data )
{
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	Mu4_Queue[Mu1_Write++] = u4_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u4* Pu4_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue4::Dequeue( u4* Pu4_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu4_Data = Mu4_Queue[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Queue.h
	引数	：	u4* Pu4_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue4::Read( u4* Pu4_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu4_Data = Mu4_Queue[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	8バイトキュークラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	エンキュー
	説明	：	キューにデータを格納し、書き込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u8 u8_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue8::Enqueue( u8 u8_Data )
{
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	Mu8_Queue[Mu1_Write++] = u8_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	Queue.h
	引数	：	u8* Pu8_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue8::Dequeue( u8* Pu8_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu8_Data = Mu8_Queue[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Queue.h
	引数	：	u8* Pu8_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Queue8::Read( u8* Pu8_Data )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*Pu8_Data = Mu8_Queue[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

