/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Queue.h
	概要		：	Mul light API - キュークラス
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数・マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	基本キュークラス
*******************************************************************************/
class	QueueBase
{
//定数
public:
	//エラー情報
	enum	Error
	{
		ERROR = _ERROR_,
		ERROR_QUEUE_NULL,		//キューにデータが入っていない。
		ERROR_QUEUE_FULL,		//キューのデータが満杯になっている。

		SUCCESS = _SUCCESS_,
	};

//変数
protected:
	u1		Mu1_Read;		//読み込み位置
	u1		Mu1_Write;		//書き込み位置

//メソッド
public:
	void	Init( void );

	//データ数取得
	u1		GetNumData( void );
};


/*******************************************************************************
	1バイトキュークラス
*******************************************************************************/
class	Queue1 : public QueueBase
{
private:
	u1		Mu1_Queue[256];			//キュー本体
public:
	s4		Enqueue( u1 u1_Data );
	s4		Dequeue( u1* Pu1_Data );
	s4		Read( u1* Pu1_Data );
};


/*******************************************************************************
	2バイトキュークラス
*******************************************************************************/
class	Queue2 : public QueueBase
{
private:
	u2		Mu2_Queue[256];			//キュー本体
public:
	s4		Enqueue( u2 u2_Data );
	s4		Dequeue( u2* Pu2_Data );
	s4		Read( u2* Pu2_Data );
};


/*******************************************************************************
	4バイトキュークラス
*******************************************************************************/
class	Queue4 : public QueueBase
{
private:
	u4		Mu4_Queue[256];			//キュー本体
public:
	s4		Enqueue( u4 u4_Data );
	s4		Dequeue( u4* Pu4_Data );
	s4		Read( u4* Pu4_Data );
};


/*******************************************************************************
	8バイトキュークラス
*******************************************************************************/
class	Queue8 : public QueueBase
{
private:
	u8		Mu8_Queue[256];			//キュー本体
public:
	s4		Enqueue( u8 u8_Data );
	s4		Dequeue( u8* Pu8_Data );
	s4		Read( u8* Pu8_Data );
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
