/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/SC.h
	概要		：	Mul light API - システムコール
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	前方宣言
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
class	SCDBase;



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	システムコールクラス
	各種システムコール情報クラスのベースクラスです。
*******************************************************************************/
class	SC
{
//定数
public:
	//システムコールID
	enum	SCID
	{
		//ファイル関連
		SCID_FILE			= 0x00000000,

		//アプリケーション関連
		SCID_APPLICATION	= 0x00010000,
		DRAW_OBJECT,			//オブジェクト描画
		REGI_WINDOW,			//ウィンドウ登録
		APL_QUIT,				//アプリケーション終了

		//Mul light標準ライブラリ
		SCID_MLSTDLIB		= 0x00020000,
		GET_RESOLUTION,			//解像度取得
		SLEEP,					//タスクスリープ
		WAKEUP,					//タスク起動
		FULL_DRAW_UPDATE,		//全再描画
	};

//メソッド
public:
	static u4	SystemCall( SCID SCID, SCDBase* P_SCD );
};


/*******************************************************************************
	システムコールデータ基本クラス
*******************************************************************************/
class	SCDBase
{
};


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
