/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Stack.cpp
	概要		：	Mul light API - スタッククラス
	詳細		：	FILOでデータの出し入れをするデータ領域です。
					256の配列で、1,2,4,8バイトのスタックがあります。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"Stack.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	基本スタッククラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	基本スタッククラスの初期化
	説明	：
	Include	：	Stack.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	StackBase::Init( void )
{
	Mui_Pointer = 0;
}


/*******************************************************************************
	概要	：	データ数の取得
	説明	：
	Include	：	Stack.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
u1		StackBase::GetNumData( void )
{
	return Mui_Pointer;
}


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	1バイトスタッククラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	プッシュ
	説明	：	スタックにデータを格納し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u1 u1_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack1::Push( u1 u1_Data )
{
	//スタックポインタが256なら、満杯
	if( Mui_Pointer == 256 )
		return ERROR_STACK_FULL;

	Mu1_Stack[Mui_Pointer++] = u1_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	ポップ
	説明	：	スタックからデータを取得し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u1* Pu1_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack1::Pop( u1* Pu1_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu1_Data = Mu1_Stack[Mui_Pointer--];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	スタックからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Stack.h
	引数	：	u1* Pu1_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack1::Read( u1* Pu1_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu1_Data = Mu1_Stack[Mui_Pointer - 1];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	2バイトスタッククラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	プッシュ
	説明	：	スタックにデータを格納し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u2 u2_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack2::Push( u2 u2_Data )
{
	//スタックポインタが256なら、満杯
	if( Mui_Pointer == 256 )
		return ERROR_STACK_FULL;

	Mu2_Stack[Mui_Pointer++] = u2_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	ポップ
	説明	：	スタックからデータを取得し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u2* Pu2_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack2::Pop( u2* Pu2_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu2_Data = Mu2_Stack[Mui_Pointer--];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	スタックからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Stack.h
	引数	：	u2* Pu2_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack2::Read( u2* Pu2_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu2_Data = Mu2_Stack[Mui_Pointer - 1];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	4バイトスタッククラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	プッシュ
	説明	：	スタックにデータを格納し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u4 u4_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack4::Push( u4 u4_Data )
{
	//スタックポインタが256なら、満杯
	if( Mui_Pointer == 256 )
		return ERROR_STACK_FULL;

	Mu4_Stack[Mui_Pointer++] = u4_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	ポップ
	説明	：	スタックからデータを取得し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u4* Pu4_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack4::Pop( u4* Pu4_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu4_Data = Mu4_Stack[Mui_Pointer--];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	スタックからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Stack.h
	引数	：	u4* Pu4_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack4::Read( u4* Pu4_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu4_Data = Mu4_Stack[Mui_Pointer - 1];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	8バイトスタッククラス
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	プッシュ
	説明	：	スタックにデータを格納し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u8 u8_Data	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack8::Push( u8 u8_Data )
{
	//スタックポインタが256なら、満杯
	if( Mui_Pointer == 256 )
		return ERROR_STACK_FULL;

	Mu8_Stack[Mui_Pointer++] = u8_Data;
	return SUCCESS;
}

/*******************************************************************************
	概要	：	ポップ
	説明	：	スタックからデータを取得し、スタックポインタをインクリメントします。
	Include	：	Stack.h
	引数	：	u8* Pu8_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack8::Pop( u8* Pu8_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu8_Data = Mu8_Stack[Mui_Pointer--];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	スタックからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	Stack.h
	引数	：	u8* Pu8_Data	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		Stack8::Read( u8* Pu8_Data )
{
	//スタックポインタが0ならデータなし。
	if( Mui_Pointer == 0 )
		return ERROR_STACK_NULL;

	*Pu8_Data = Mu8_Stack[Mui_Pointer - 1];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

