/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.optimizer.TypeEvent;

public class OptLocalVariable
extends LocalVariable {
    private short itsJRegister = (short)-1;
    private boolean itsLiveAcrossCall;
    private boolean itsIsNumber;
    private TypeEvent itsTypeUnion;
    private int initPC;

    public OptLocalVariable(String string, boolean bl) {
        super(string, bl);
        int n = bl ? 3 : 0;
        this.itsTypeUnion = new TypeEvent(n);
    }

    public String toString() {
        return "LocalVariable : '" + this.getName() + "', index = " + this.getIndex() + ", LiveAcrossCall = " + this.itsLiveAcrossCall + ", isNumber = " + this.itsIsNumber + ", isParameter = " + this.isParameter() + ", JRegister = " + this.itsJRegister;
    }

    public void setIsNumber() {
        this.itsIsNumber = true;
    }

    public boolean isNumber() {
        return this.itsIsNumber;
    }

    public void markLiveAcrossCall() {
        this.itsLiveAcrossCall = true;
    }

    public void clearLiveAcrossCall() {
        this.itsLiveAcrossCall = false;
    }

    public boolean isLiveAcrossCall() {
        return this.itsLiveAcrossCall;
    }

    public void assignJRegister(short s) {
        this.itsJRegister = s;
    }

    public short getJRegister() {
        return this.itsJRegister;
    }

    public boolean assignType(int n) {
        return this.itsTypeUnion.add(n);
    }

    public int getTypeUnion() {
        return this.itsTypeUnion.getEvent();
    }

    public int getStartPC() {
        return this.initPC;
    }

    public void setStartPC(int n) {
        this.initPC = n;
    }
}

