/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class PositionIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int position = 0;
    private int min;
    private int max;
    private Item nextItem = null;
    private Item current = null;

    private PositionIterator(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        this.base = sequenceIterator;
        this.min = n;
        if (n < 1) {
            n = 1;
        }
        this.max = n2;
        if (n2 < n) {
            this.nextItem = null;
            return;
        }
        int n3 = 1;
        while (n3++ <= n) {
            this.nextItem = sequenceIterator.next();
            if (this.nextItem != null) continue;
        }
        this.current = this.nextItem;
    }

    public static SequenceIterator make(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(n, n2);
        }
        if (n2 == Integer.MAX_VALUE) {
            return TailIterator.make(sequenceIterator, n);
        }
        return new PositionIterator(sequenceIterator, n, n2);
    }

    public boolean hasNext() {
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        if (this.nextItem == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.nextItem;
        ++this.position;
        this.nextItem = this.base.position() < this.max ? this.base.next() : null;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new PositionIterator(this.base.getAnother(), this.min, this.max);
    }

    public int getProperties() {
        int n = 4;
        return n |= this.base.getProperties() & 2;
    }

    public int getLastPosition() throws XPathException {
        int n = ((LastPositionFinder)this.base).getLastPosition();
        int n2 = Math.min(n, this.max);
        return Math.max(n2 - this.min + 1, 0);
    }
}

