/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.om.VirtualCopy;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public class CopyOf
extends Instruction {
    private Expression select;
    private boolean copyNamespaces;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private boolean rejectDuplicateAttributes;
    private boolean readOnce = false;
    private boolean validating;

    public CopyOf(Expression expression, boolean bl, int n, SchemaType schemaType, boolean bl2) {
        this.select = expression;
        this.copyNamespaces = bl;
        this.validation = n;
        this.schemaType = schemaType;
        this.validating = schemaType != null || n != 3;
        this.rejectDuplicateAttributes = bl2;
        this.adoptChildExpression(expression);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public void setReadOnce(boolean bl) {
        this.readOnce = bl;
    }

    public final boolean createsNewNodes() {
        Executable executable = this.getExecutable();
        if (executable == null) {
            return true;
        }
        TypeHierarchy typeHierarchy = executable.getConfiguration().getTypeHierarchy();
        return !this.select.getItemType(typeHierarchy).isAtomicType();
    }

    public int getInstructionNameCode() {
        return 140;
    }

    public void setRequireDocumentOrElement(boolean bl) {
        this.requireDocumentOrElement = bl;
    }

    public boolean isDocumentOrElementRequired() {
        return this.requireDocumentOrElement;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        boolean bl = sequenceReceiver.getSystemId() == null;
        int n = this.copyNamespaces ? 2 : 0;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                Object object;
                NodeInfo nodeInfo = (NodeInfo)item;
                int n2 = nodeInfo.getNodeKind();
                if (this.requireDocumentOrElement && n2 != 1 && n2 != 9) {
                    object = new DynamicError("Operand of validate expression must be a document or element node");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    ((XPathException)object).setErrorCode("XQTY0030");
                    throw object;
                }
                switch (n2) {
                    case 1: {
                        object = sequenceReceiver;
                        if (this.validating) {
                            object = controller.getConfiguration().getElementValidator(sequenceReceiver, nodeInfo.getNameCode(), this.locationId, this.schemaType, this.validation);
                        }
                        if (bl) {
                            object.setSystemId(nodeInfo.getBaseURI());
                        }
                        try {
                            nodeInfo.copy((Receiver)object, n, true, this.locationId);
                            break;
                        }
                        catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                            copyNamespaceSensitiveException.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw copyNamespaceSensitiveException;
                        }
                    }
                    case 2: {
                        try {
                            CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, this, xPathContext, this.rejectDuplicateAttributes);
                            break;
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setLocator(this);
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, dynamicError, xPathContext);
                        }
                    }
                    case 3: {
                        sequenceReceiver.characters(nodeInfo.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 7: {
                        if (bl) {
                            sequenceReceiver.setSystemId(nodeInfo.getBaseURI());
                        }
                        sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 8: {
                        sequenceReceiver.comment(nodeInfo.getStringValueCS(), this.locationId, 0);
                        break;
                    }
                    case 13: {
                        try {
                            nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                            break;
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, dynamicError, xPathContext);
                        }
                    }
                    case 9: {
                        Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), this.validation, 10, this.schemaType);
                        receiver.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
                        if (bl) {
                            receiver.setSystemId(nodeInfo.getBaseURI());
                        }
                        try {
                            nodeInfo.copy(receiver, n, true, this.locationId);
                            break;
                        }
                        catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                            copyNamespaceSensitiveException.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw copyNamespaceSensitiveException;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
                    }
                }
                continue;
            }
            sequenceReceiver.append(item, this.locationId, 2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyAttribute(NodeInfo nodeInfo, SchemaType schemaType, int n, Instruction instruction, XPathContext xPathContext, boolean bl) throws XPathException {
        SchemaType schemaType2;
        int n2 = nodeInfo.getNameCode();
        int n3 = 631;
        int n4 = 0;
        if (bl) {
            n4 |= 0x20;
        }
        CharSequence charSequence = nodeInfo.getStringValueCS();
        if (schemaType != null) {
            if (!schemaType.isSimpleType()) {
                DynamicError dynamicError = new DynamicError("Cannot validate an attribute against a complex type");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTSE1530");
                throw dynamicError;
            }
            if (((SimpleType)schemaType).isNamespaceSensitive()) {
                DynamicError dynamicError = new DynamicError("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                dynamicError.setErrorCode("XTTE1545");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(instruction);
                throw dynamicError;
            }
            try {
                ValidationException validationException = ((SimpleType)schemaType).validateContent(charSequence, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
                if (validationException != null) {
                    throw new ValidationException("Attribute being copied does not match the required type. " + validationException.getMessage());
                }
                n3 = schemaType.getFingerprint();
            }
            catch (UnresolvedReferenceException unresolvedReferenceException) {
                throw new ValidationException(unresolvedReferenceException);
            }
        } else if (n == 1 || n == 2) {
            try {
                n3 = xPathContext.getConfiguration().validateAttribute(n2, charSequence, n);
            }
            catch (ValidationException validationException) {
                DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(instruction);
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
        } else if (n == 3 && (n3 = nodeInfo.getTypeAnnotation() & 0xFFFFF) != 631 && ((AtomicType)(schemaType2 = xPathContext.getConfiguration().getSchemaType(n3))).isNamespaceSensitive()) {
            DynamicError dynamicError = new DynamicError("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            dynamicError.setErrorCode("XTTE0950");
            dynamicError.setIsTypeError(true);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        xPathContext.getReceiver().attribute(n2, n3, charSequence, instruction.getLocationId(), n4);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.schemaType != null) {
            Configuration configuration = this.getExecutable().getConfiguration();
            ItemType itemType = this.select.getItemType(typeHierarchy);
            int n = typeHierarchy.relationship(itemType, NodeKindTest.ELEMENT);
            if (n == 0 || n == 2) {
                return new ContentTypeTest(1, this.schemaType, configuration);
            }
            int n2 = typeHierarchy.relationship(itemType, NodeKindTest.ATTRIBUTE);
            if (n2 == 0 || n2 == 2) {
                return new ContentTypeTest(2, this.schemaType, configuration);
            }
        }
        return this.select.getItemType(typeHierarchy);
    }

    public int getCardinality() {
        return this.select.getCardinality();
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        if (this.isDocumentOrElementRequired()) {
            ItemType itemType2;
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            if (typeHierarchy.isSubType(itemType2 = this.select.getItemType(typeHierarchy), NodeKindTest.ATTRIBUTE)) {
                throw new DynamicError("validate{} expression cannot be applied to an attribute", "XQTY0030");
            }
            if (typeHierarchy.isSubType(itemType2, NodeKindTest.TEXT)) {
                throw new DynamicError("validate{} expression cannot be applied to a text node", "XQTY0030");
            }
            if (typeHierarchy.isSubType(itemType2, NodeKindTest.COMMENT)) {
                throw new DynamicError("validate{} expression cannot be applied to a comment node", "XQTY0030");
            }
            if (typeHierarchy.isSubType(itemType2, NodeKindTest.PROCESSING_INSTRUCTION)) {
                throw new DynamicError("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
            }
            if (typeHierarchy.isSubType(itemType2, NodeKindTest.NAMESPACE)) {
                throw new DynamicError("validate{} expression cannot be applied to a namespace node", "XQTY0030");
            }
        }
        this.adoptChildExpression(this.select);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        if (this.readOnce && (expression = optimizer.optimizeCopy(this.select)) != null) {
            return expression;
        }
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        return this;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "copyOf " + "validation=" + Validation.toString(this.validation));
        this.select.display(n + 1, printStream, configuration);
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        return bl;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return super.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        if (this.validation == 3 && this.schemaType == null && this.copyNamespaces) {
            ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                public Item map(Item item) {
                    if (item instanceof AtomicValue) {
                        return item;
                    }
                    VirtualCopy virtualCopy = VirtualCopy.makeVirtualCopy((NodeInfo)item, (NodeInfo)item);
                    int n = xPathContext.getController().getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber();
                    virtualCopy.setDocumentNumber(n);
                    return virtualCopy;
                }
            };
            return new ItemMappingIterator(this.select.iterate(xPathContext), itemMappingFunction);
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setReceiver(sequenceOutputter);
        try {
            this.process(xPathContextMinor);
            return Value.getIterator(sequenceOutputter.getSequence());
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }
}

