/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NamespaceIterator
implements AxisIterator {
    private NodeInfo element;
    private NodeTest test;
    private int index;
    private int position;
    private NamespaceNodeImpl next;
    private NamespaceNodeImpl current;
    private IntIterator nsIterator;
    private static int[] XML_NAMESPACE_CODE_ARRAY = new int[]{65537};

    public static AxisIterator makeIterator(NodeInfo nodeInfo, NodeTest nodeTest) {
        Object object;
        boolean bl = true;
        if (nodeTest instanceof AnyNodeTest || nodeTest == NodeKindTest.NAMESPACE) {
            nodeTest = null;
        }
        NamespaceIterator namespaceIterator = null;
        IntHashSet intHashSet = null;
        IntHashSet intHashSet2 = null;
        int[] nArray = new int[8];
        for (NodeInfo nodeInfo2 = nodeInfo; nodeInfo2 != null && nodeInfo2.getNodeKind() == 1; nodeInfo2 = nodeInfo2.getParent()) {
            object = nodeInfo2.getDeclaredNamespaces(nArray);
            if (object == null) continue;
            for (int i = 0; i < ((int[])object).length && object[i] != -1; ++i) {
                if (bl) {
                    NamespaceIterator namespaceIterator2 = new NamespaceIterator();
                    namespaceIterator2.element = nodeInfo;
                    namespaceIterator2.test = nodeTest;
                    namespaceIterator2.index = -1;
                    intHashSet2 = new IntHashSet(8);
                    intHashSet = new IntHashSet(8);
                    intHashSet.add(65537);
                    bl = false;
                    namespaceIterator = namespaceIterator2;
                }
                short s = (short)(object[i] & 0xFFFF);
                short s2 = (short)(object[i] >> 16);
                if (s == 0) {
                    intHashSet2.add(s2);
                    continue;
                }
                if (intHashSet2.contains(s2)) continue;
                intHashSet.add(object[i]);
                intHashSet2.add(s2);
            }
        }
        if (namespaceIterator == null) {
            object = new NamespaceNodeImpl(nodeInfo, 65537, 0);
            if (nodeTest == null) {
                return SingleNodeIterator.makeIterator((NodeInfo)object);
            }
            return Navigator.filteredSingleton((NodeInfo)object, nodeTest);
        }
        ((NamespaceIterator)namespaceIterator).nsIterator = intHashSet.iterator();
        return namespaceIterator;
    }

    private NamespaceIterator() {
    }

    public void advance() {
        while (this.nsIterator.hasNext()) {
            int n = this.nsIterator.next();
            this.next = new NamespaceNodeImpl(this.element, n, ++this.index);
            if (this.test != null && !this.test.matches(this.next)) continue;
            return;
        }
        this.next = null;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public Item next() {
        if (this.index == -1) {
            this.advance();
            this.index = 0;
        }
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.advance();
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return this.current.iterateAxis(by, nodeTest);
    }

    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    public SequenceIterator getAnother() {
        return NamespaceIterator.makeIterator(this.element, this.test);
    }

    public int getProperties() {
        return 0;
    }

    public static int[] getInScopeNamespaceCodes(NodeInfo nodeInfo) {
        int n;
        int[] nArray;
        boolean bl = true;
        IntHashSet intHashSet = null;
        IntHashSet intHashSet2 = null;
        int[] nArray2 = new int[8];
        for (NodeInfo nodeInfo2 = nodeInfo; nodeInfo2 != null && nodeInfo2.getNodeKind() == 1; nodeInfo2 = nodeInfo2.getParent()) {
            nArray = nodeInfo2.getDeclaredNamespaces(nArray2);
            if (nArray == null) continue;
            for (n = 0; n < nArray.length && nArray[n] != -1; ++n) {
                if (bl) {
                    intHashSet2 = new IntHashSet(8);
                    intHashSet = new IntHashSet(8);
                    intHashSet.add(65537);
                    bl = false;
                }
                short s = (short)(nArray[n] & 0xFFFF);
                short s2 = (short)(nArray[n] >> 16);
                if (s == 0) {
                    intHashSet2.add(s2);
                    continue;
                }
                if (intHashSet2.contains(s2)) continue;
                intHashSet.add(nArray[n]);
                intHashSet2.add(s2);
            }
        }
        if (bl) {
            return XML_NAMESPACE_CODE_ARRAY;
        }
        nArray = new int[intHashSet.size()];
        n = 0;
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            nArray[n++] = intIterator.next();
        }
        return nArray;
    }

    public static class NamespaceNodeImpl
    implements NodeInfo,
    FingerprintedNode {
        NodeInfo element;
        int nscode;
        int position;
        int namecode;

        public NamespaceNodeImpl(NodeInfo nodeInfo, int n, int n2) {
            this.element = nodeInfo;
            this.nscode = n;
            this.position = n2;
            NamePool namePool = nodeInfo.getNamePool();
            String string = namePool.getPrefixFromNamespaceCode(n);
            this.namecode = "".equals(string) ? -1 : namePool.allocate("", "", string);
        }

        public int getNodeKind() {
            return 13;
        }

        public boolean isSameNodeInfo(NodeInfo nodeInfo) {
            if (!(nodeInfo instanceof NamespaceNodeImpl)) {
                return false;
            }
            return this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element) && this.nscode == ((NamespaceNodeImpl)nodeInfo).nscode;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeInfo) {
                return this.isSameNodeInfo((NodeInfo)object);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.element).hashCode() ^ this.position << 13;
        }

        public String getSystemId() {
            return this.element.getSystemId();
        }

        public String getBaseURI() {
            return null;
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public int compareOrder(NodeInfo nodeInfo) {
            if (nodeInfo instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element)) {
                int n = this.position - ((NamespaceNodeImpl)nodeInfo).position;
                if (n == 0) {
                    return 0;
                }
                if (n < 0) {
                    return -1;
                }
                return 1;
            }
            if (this.element.isSameNodeInfo(nodeInfo)) {
                return 1;
            }
            return this.element.compareOrder(nodeInfo);
        }

        public String getStringValue() {
            return this.element.getNamePool().getURIFromURICode((short)(this.nscode & 0xFFFF));
        }

        public CharSequence getStringValueCS() {
            return this.getStringValue();
        }

        public int getNameCode() {
            return this.namecode;
        }

        public int getFingerprint() {
            if (this.namecode == -1) {
                return -1;
            }
            return this.namecode & 0xFFFFF;
        }

        public String getLocalPart() {
            if (this.namecode == -1) {
                return "";
            }
            return this.element.getNamePool().getLocalName(this.namecode);
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return this.getLocalPart();
        }

        public String getPrefix() {
            return "";
        }

        public Configuration getConfiguration() {
            return this.element.getConfiguration();
        }

        public NamePool getNamePool() {
            return this.element.getNamePool();
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public NodeInfo getParent() {
            return this.element;
        }

        public AxisIterator iterateAxis(byte by) {
            return this.iterateAxis(by, AnyNodeTest.getInstance());
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: {
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 1: {
                    if (nodeTest.matches(this)) {
                        return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                    }
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 9: {
                    return Navigator.filteredSingleton(this.element, nodeTest);
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public String getAttributeValue(int n) {
            return null;
        }

        public NodeInfo getRoot() {
            return this.element.getRoot();
        }

        public DocumentInfo getDocumentRoot() {
            return this.element.getDocumentRoot();
        }

        public boolean hasChildNodes() {
            return false;
        }

        public void generateId(FastStringBuffer fastStringBuffer) {
            this.element.generateId(fastStringBuffer);
            fastStringBuffer.append("n");
            fastStringBuffer.append(Integer.toString(this.position));
        }

        public int getDocumentNumber() {
            return this.element.getDocumentNumber();
        }

        public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
            receiver.namespace(this.nscode, 32);
        }

        public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        }

        public int[] getDeclaredNamespaces(int[] nArray) {
            return null;
        }

        public void setSystemId(String string) {
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
        }

        public Value atomize() throws XPathException {
            return new StringValue(this.getStringValueCS());
        }
    }
}

