using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Acl.Models.Base;
using OFW.Models;

namespace OFW.Acl.Models
{
    /// <summary>
    /// AclResources GeBeB`
    /// </summary>
    [Serializable()]
    public class AclResourcesEntity : AclResourcesTableRow, ICloneable, OFW.Acl.IAclResource
	{
        /// <summary>
        /// qvf̃Xg
        /// </summary>
        List<AclResourcesEntity> _children;
        /// <summary>
        /// evf
        /// </summary>
        AclResourcesEntity _parent;
        /// <summary>
        /// e̖O
        /// </summary>
        public string parentName;

        /// <summary>
        /// ftHg\z
        /// </summary>
        public AclResourcesEntity() : base()
        {
            _children = new List<AclResourcesEntity>();
            _parent = null;
        }
	
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public override object Clone()
        {
            AclResourcesEntity clone = new AclResourcesEntity();
            clone.CopyFrom(this);
			
			//TODO: ɂ̃NX̓Ǝ̃N[

            return clone;
        }
        /// <summary>
        /// nꂽp[^IuWFNg̓ẽIuWFNgɃRs[B
        /// </summary>
        /// <param name="source">Rs[̃GeBeB</param>
        public virtual void CopyFrom(AclResourcesEntity source)
        {
        	base.CopyFrom(source);

			//TODO: ɂ̃NX̓Ǝ̃Rs[
        }




        #region ITreeNode o

        /// <summary>
        /// qvf邩
        /// </summary>
        public bool hasChild
        {
            get { return (rightSide - leftSide ) > 1; }
        }
        /// <summary>
        /// ̗vfwvf̐e(c)ł邩
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public bool isAncestorOf(OFW.Models.ITreeNode target)
        {
            AclResourcesEntity entity = target as AclResourcesEntity;

            return (entity.leftSide > leftSide && entity.leftSide < rightSide);
        }
        /// <summary>
        /// ̗vfwvf̎q(q)ł邩
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public bool isDescendantOf(OFW.Models.ITreeNode target)
        {
            return target.isAncestorOf(this);
        }
        /// <summary>
        /// qvf̗
        /// </summary>
        public IEnumerable<OFW.Models.ITreeNode> children
        {
            get
            {
                return _children.ToArray();
            }
            set
            {
                _children.Clear();
                IEnumerator<ITreeNode> e = value.GetEnumerator();
                while (e.MoveNext())
                {
                    _children.Add(e.Current as AclResourcesEntity);
                }
            }
        }
        /// <summary>
        /// evf
        /// </summary>
        public OFW.Models.ITreeNode parent
        {
            get
            {
                return _parent;
            }
            set
            {
                _parent = value as AclResourcesEntity;
            }
        }
        /// <summary>
        /// qǉ
        /// </summary>
        /// <param name="child"></param>
        public void appendChild(OFW.Models.ITreeNode child)
        {
            _children.Add(child as AclResourcesEntity);
            child.parent = this;
        }
        /// <summary>
        /// q폜
        /// </summary>
        /// <param name="child"></param>
        public void removeChild(OFW.Models.ITreeNode child)
        {
            AclResourcesEntity childNode = child as AclResourcesEntity;
            int position = _children.FindIndex(delegate(AclResourcesEntity t) { return t.name == childNode.name; });
            if (position < 0)
            {
            }
            else
            {
                _children.RemoveAt(position);
            }
        }
        /// <summary>
        /// pX
        /// </summary>
        public string pathString
        {
            get { return TreeNode.createPathString(this); }
        }
        /// <summary>
        /// pX̃Xg
        /// </summary>
        public List<string> path
        {
            get { return TreeNode.createPath(this); }
        }
        /// <summary>
        /// pXɈvvf
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public OFW.Models.ITreeNode find(IEnumerable<string> path)
        {
            return TreeNode.find(this,path);;
        }

        #endregion
        /// <summary>
        /// f[^̃}bsO
        /// </summary>
        /// <param name="row"></param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("parent_name")) { this.parentName = StringUtil.StringValue(row["parent_name"]); }
            base.Map(row);
        }
    }

}