using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;
using OFW.Models;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Database.CommandBuilder;
using OFW.Database.Expressions;

namespace OFW.Database
{
    /// <summary>
    /// [EXPERIMENTAL]
    /// ֘AčsI
    /// </summary>
    public class AssociationSelect<TEntity> where TEntity : Entity, new()
    {
        Connection connection;
        EntityProperty baseEntityProperty;
        List<Association> associationsToOne;
        List<Association> associationsToMany;
        Command command;
        Criteria criteria;
        Dictionary<string, PropertyInfo> referenceFieldProperty;

        Dictionary<string, Type> referenceFieldListType;
        Dictionary<string, MethodInfo> mapMethod;
        Dictionary<string, ConstructorInfo> constructors;
        Type baseEntityType;
        /// <summary>
        /// ֘Aǂ[w肷
        /// </summary>
        public int associationDepth = 2;

        SelectCommandBuilder commandBuilder;
        bool columnRequired = true;

        /// <summary>
        /// ftHg̍\z
        /// </summary>
        public AssociationSelect()
        {
            connection = ConnectionFactory.GetConnectionByName("default");
            initialize();
            
        }
        /// <summary>
        /// ڑw肷\z
        /// </summary>
        /// <param name="connection"></param>
        public AssociationSelect(Connection connection)
        {
            this.connection = connection;
            initialize();
        }
        void initialize()
        {
            baseEntityProperty = null;
            associationsToOne = new List<Association>();
            associationsToMany = new List<Association>();
            referenceFieldProperty = new Dictionary<string, PropertyInfo>();
            referenceFieldListType = new Dictionary<string, Type>();
            mapMethod = new Dictionary<string, MethodInfo>();
            constructors = new Dictionary<string, ConstructorInfo>();
            criteria = new Criteria();
            commandBuilder = new SelectCommandBuilder(connection);
        }
        /// <summary>
        /// {e[uݒ肷B
        /// </summary>
        /// <param name="property"></param>
        /// <returns></returns>
        public AssociationSelect<TEntity> from(EntityProperty property)
        {
            baseEntityProperty = property;
            baseEntityType = baseEntityProperty.entityType;
            return this;
        }
        /// <summary>
        /// ֘Aǉ
        /// </summary>
        /// <param name="associations"></param>
        public AssociationSelect<TEntity> associate(params Association[] associations)
        {
            if (associations == null) return this;
            foreach (Association assoc in associations)
            {
                switch (assoc.multiplicity)
                {
                    case Association.Multiplicity.TO_ONE:
                        associationsToOne.Add(assoc);
                        break;
                    case Association.Multiplicity.TO_MANY:
                        associationsToMany.Add(assoc);
                        break;
                    default:
                        break;
                }
            }
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        public AssociationSelect<TEntity> select(string column)
        {
            commandBuilder.select(column);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="columns"></param>
        public AssociationSelect<TEntity> select(IEnumerable<string> columns)
        {
            commandBuilder.select(columns);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        /// <param name="alias"></param>
        public AssociationSelect<TEntity> select(string column, string alias)
        {
            commandBuilder.select(column,alias);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        public AssociationSelect<TEntity> select(FieldProperty column)
        {
            commandBuilder.select(column);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="column"></param>
        /// <param name="alias"></param>
        public AssociationSelect<TEntity> select(FieldProperty column, string alias)
        {
            commandBuilder.select(column,alias);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Iݒ
        /// </summary>
        /// <param name="columns"></param>
        public AssociationSelect<TEntity> select(IEnumerable<FieldProperty> columns)
        {
            commandBuilder.select(columns);
            columnRequired = false;
            return this;
        }
        /// <summary>
        /// Criteriaݒ肷B
        /// </summary>
        /// <param name="criteria"></param>
        public AssociationSelect<TEntity> setCriteria(Criteria criteria)
        {
            this.criteria = criteria;
            return this;
        }
        /// <summary>
        /// CommandgݗĂĕԂB
        /// </summary>
        /// <remarks>Ƀ[gڑgexecuteQueryBatchȂǂgׁB</remarks>
        /// <returns></returns>
        public Command getCommand()
        {
            buildCommand();
            return command;
        }
        /// <summary>
        /// NG[sDataSet𓾂B
        /// </summary>
        /// <returns></returns>
        public DataSet query()
        {
            buildCommand();
            DataSet result = command.ExecuteQuery();
            return result;
        }
        /// <summary>
        /// NG[sʂ֘AɊÂGeBeBƂ̊֘AGeBeBɃ}bvĕԂ
        /// </summary>
        /// <returns></returns>
        public List<TEntity> queryAsEntity()
        {

            buildCommand();
            DataSet result = command.ExecuteQuery();

            AssociationMapper<TEntity> mapper = new AssociationMapper<TEntity>();
            mapper.add(associationsToOne.ToArray());
            mapper.add(associationsToMany.ToArray());
            mapper.baseTableProperty = baseEntityProperty;

            return mapper.map(result);

        }
        /// <summary>
        /// ɃNG[ʂDataSetƂđ݂ꍇADataSetEntityXgmap
        /// </summary>
        /// <param name="original"></param>
        /// <returns></returns>
        public List<TEntity> mapToEntity(DataSet original)
        {
            List<TEntity> list = new List<TEntity>();

            DataRowCollection rows = original.Tables[0].Rows;


            string baseAlias = baseEntityProperty.Alias;
            if (baseAlias == "") baseAlias = baseEntityProperty.EntityName;

            Type baseEntityType = typeof(TEntity);
            TEntity prev = null;
            TEntity current = null;
            TEntity entity = null;

            foreach (DataRow row in rows)
            {
                current = new TEntity();
                current.Map(row, baseAlias);


                if (!keyEquals(current,prev))
                {
                    entity = current;
                    list.Add(entity);

                    if (associationDepth > 0)
                    {
                        foreach (Association reference in associationsToOne)
                        {
                            mapAssociation(entity, reference, row, 1);
                        }
                    }
                }


                if (associationDepth > 0)
                {
                    foreach (Association reference in associationsToMany)
                    {
                        mapAssociation(entity, reference, row, 1);
                    }
                }
                prev = current;
            }

            return list;
        }
        bool keyEquals(TEntity entity1, TEntity entity2)
        {
            if (entity1 == null) return false;
            if (entity2 == null) return false;
            bool equals = true;
            bool tested = false;
            foreach (FieldProperty keyField in baseEntityProperty.PrimaryKeys())
            {
                tested = true;
                object keyFieldValue1 = entity1.GetValue(keyField.FieldName);
                object keyFieldValue2 = entity2.GetValue(keyField.FieldName);
                if (!keyFieldValue1.Equals(keyFieldValue2))
                {
                    equals = false;
                    break;
                }
            }
            return equals & tested;
        }
        private void buildCommand()
        {
            commandBuilder.from(baseEntityProperty);
            if (columnRequired)
            {
                commandBuilder.select(baseEntityProperty.Fields());
            }
            foreach (Association reference in associationsToOne)
            {
                buildJoin(commandBuilder, reference,1);
            }
            foreach (Association reference in associationsToMany)
            {
                buildJoin(commandBuilder, reference, 1);
            }

            commandBuilder.setCriteria(criteria);
            //TODO: paginate
            command = commandBuilder.getCommand();
            command.SetConnection(connection);
        }
        private void buildJoin(SelectCommandBuilder builder, Association association,int depth)
        {

            if (columnRequired)
            {
                commandBuilder.select(association.baseTable.Fields());
            }

            string tableName = association.baseTable.FullName;
            string alias = association.baseTable.Alias;
            if (alias == "") alias = tableName;
            builder.joinLeft(tableName, alias, association.conditions.ToArray());
            depth++;
            if (depth > associationDepth) return;

            foreach (Association assoc in association.associationsToOne)
            {
                buildJoin(builder, assoc,depth );
            }
            foreach (Association assoc in association.associationsToMany)
            {
                buildJoin(builder, assoc, depth);
            }

        }
        private PropertyInfo findReferenceFieldProperty(Type entityType,string propertyName)
        {
            string key = entityType.FullName + "#" + propertyName;
            if (referenceFieldProperty.ContainsKey(key))
            {
                return referenceFieldProperty[key];
            }
            PropertyInfo pi = entityType.GetProperty(propertyName);
            referenceFieldProperty[key] = pi;

            return pi;
        }
        private MethodInfo findMapMethod(Type entityType)
        {
            string key = entityType.FullName + "#" + "Map";
            if (mapMethod.ContainsKey(key))
            {
                return mapMethod[key];
            }
            MethodInfo pi = entityType.GetMethod("Map", new Type[] { typeof(DataRow),typeof(string) });
            mapMethod[key] = pi;

            return pi;
        }
        private ConstructorInfo findConstructor(Type entityType)
        {
            string key = entityType.FullName;
            if (constructors.ContainsKey(key))
            {
                return constructors[key];
            }
            ConstructorInfo pi = entityType.GetConstructor(new Type[] { });
            constructors[key] = pi;

            return pi;
        }
        private Type findReferenceFieldListType(Type entityType, string propertyName)
        {
            string key = entityType.FullName + "#" + propertyName;
            if (referenceFieldListType.ContainsKey(key))
            {
                return referenceFieldListType[key];
            }
            PropertyInfo pi = findReferenceFieldProperty(entityType,propertyName);
            if (pi == null) return null;

            Type ilistType = pi.PropertyType.GetInterface("System.Collections.IList");
                referenceFieldListType[key] = ilistType;//nullłǉĂ

            return ilistType;
        }

        private void mapAssociation(Entity entity, Association reference, DataRow row, int depth)
        {
            if (reference.createEntity != null)
            {
                reference.createEntity(row, reference.baseTable.Alias);
                return;
            }
            Entity referenceEntity = createAssociationObject(reference, row);
            if (!referenceEntity.isEmpty())
            {
                PropertyInfo pi = findReferenceFieldProperty(entity.GetType(), reference.name);
                if (pi != null)
                {
                    Type ilistType = findReferenceFieldListType(entity.GetType(), reference.name);
                    if (ilistType != null)
                    {
                        //Xĝ̂擾
                        object targetList = pi.GetValue(entity, null);
                        if (targetList == null)
                        {
                            targetList = Activator.CreateInstance(pi.PropertyType);
                            pi.SetValue(entity, targetList, null);
                        }
                        ilistType.InvokeMember("Add", BindingFlags.InvokeMethod, null, targetList, new object[] { referenceEntity });
                    }
                    else
                    {
                        pi.SetValue(entity, referenceEntity, null);
                    }
                }
                depth++;
                if (depth > associationDepth) return;
                foreach (Association assoc in reference.associationsToMany)
                {
                    mapAssociation(referenceEntity, assoc, row, depth);
                }
            }
        }
        private Entity createAssociationObject(Association reference, DataRow row)
        {
            if (reference.baseTable.entityType != null)
            {
                string alias = reference.baseTable.Alias;
                if (alias == "") alias = reference.baseTable.EntityName;
                ConstructorInfo constructor = findConstructor(reference.baseTable.entityType);
                if(constructor == null) return null;

                object refObject = constructor.Invoke(null);
                MethodInfo mi = findMapMethod(reference.baseTable.entityType);
                if (mi != null)
                {
                    mi.Invoke(refObject, new object[] { row, alias });
                }

                return refObject as Entity;
            }
            return null;
        }

    }
}

