using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using OFW.Models;
using OFW.Log;
using OFW.Serializer;

namespace OFW.Database
{
    /// <summary>
    /// f[^x[Xւ̐ڑ
    /// </summary>
    /// <remarks>ʂSystem.Data.Common.DbConnection𒼐ڎgpAvO~Oڑf[^x[XɈˑȂ@\񋟂B
    /// <p>NX̃CX^X͒ڐAConnectionFactory#getConnection ܂ConnectionFactory#getConnectionByNamegpăCX^X擾B</p>
    /// <p>̐ڑꍇAڑɖOĂ̖Oɐڑ𓾂B</p>
    /// </remarks>
    /// <example>
    /// AvP[V̊̐ڑgpăNG[s
    /// <code>Connection connection = ConnectionFactory.getConnectionByName("default");
    /// Command command = new Command("select * from users where user_id = @user_id");
    /// command.SetParameter(new Parameter("@user_id",DbType.Int32,1);
    /// DateSet result = connection.ExecuteQuery(command);
    /// </code>
    /// ʂ̖O̐ڑg
    /// <code>Connection connection = ConnectionFactory.getConnectionByName("anotherConnection");
    /// Command command = new Command("select * from users where user_id = @user_id");
    /// command.SetParameter(new Parameter("@user_id",DbType.Int32,1);
    /// DateSet result = connection.ExecuteQuery(command);
    /// </code>
    /// "/"ŋ؂ꂽO̐ڑg
    /// // app.config/dataAccess name="example/A001" ƖOtꂽڑgBȂ example,ɌȂ defaultgp
    /// <code>Connection connection = ConnectionFactory.getConnectionByName("example","A001");
    /// Command command = new Command("select * from users where user_id = @user_id");
    /// command.SetParameter(new Parameter("@user_id",DbType.Int32,1);
    /// DateSet result = connection.ExecuteQuery(command);
    /// </code>
    /// 
    /// </example>
    public abstract class Connection :IDisposable
    {
        /// <summary>
        /// Oo
        /// </summary>
        private OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);
        /// <summary>
        /// app.config/dataAccess̗vfɂ̐ڑ̖OB
        /// </summary>
        public string name;

        /// <summary>
        /// ̐ڑ̂߂̐ݒ
        /// </summary>
        protected Config.ConnectionConfigElement config;
        /// <summary>
        /// ڑ^CAEgBڑ܂ł̃^CAEgłăR}hs̃^CAEgȂ
        /// </summary>
        protected int connectionTimeout;
        /// <summary>
        /// R}hs^CAEgB
        /// </summary>
        protected int commandTimeout;
        /// <summary>
        /// pX^C(SqlServer^CvȂ)
        /// </summary>
        protected int quoteStyle;
        /// <summary>
        /// gUNVx
        /// </summary>
        protected IsolationLevel isolation;
        /// <summary>
        /// ݎgp̃[U[
        /// </summary>
        protected internal OFW.Auth.IUser currentUser = null;
        /// <summary>
        /// 
        /// </summary>
        protected int connectionCount = 0;
        /// <summary>
        /// 
        /// </summary>
        protected int transactionCount = 0;

        /// <summary>
        /// J^O(ʓIɂ̓f[^x[X)
        /// </summary>
        public string Catalog
        {
            get
            {
                return config.Database;
            }
        }

        /// <summary>
        /// ʎqpň͂ޕKv
        /// </summary>
        protected bool quoteIdentifier;
        /// <summary>
        /// ʎqpň͂ޕKv
        /// </summary>
        public bool QuotedIdentifier
        {
            get { return quoteIdentifier; }
            set { quoteIdentifier = value; }
        }

        /// <summary>
        /// \z
        /// </summary>
        protected Connection()
	    {
            //no op
	    }
        /// <summary>
        /// DataAccessConfigɂ鏉
        /// </summary>/// <param name="config"></param>
        internal void Init(Config.ConnectionConfigElement config)
        {
            this.config = config;
            Config.ConnectionConfigSection sect = (Config.ConnectionConfigSection)OFW.Config.ConfigFactory.GetConfig().GetSection("dataAccess");

            if (config.CommandTimeout == 0) this.commandTimeout = sect.DefaultCommandTimeout;
            else this.commandTimeout = config.CommandTimeout;

            if (config.ConnectionTimeout == 0) this.connectionTimeout = sect.DefaultConnectionTimeout;
            else this.connectionTimeout = config.ConnectionTimeout;

            this.quoteStyle = config.QuoteStyle;
            isolation = IsolationLevel.ReadUncommitted;
        }
        internal void LoadCurrentUser()
        {
            Auth.AuthProvider provider = Auth.AuthProviderFactory.GetInstance();
            Auth.Identity id = provider.GetIdentity();
            if (id == null)
            {
                currentUser = new OFW.Auth.NullUser();
            }
            else
            {
                currentUser = id.User;
            }
        }
        /// <summary>
        /// ڑJ
        /// gUNVxIsolationLevel.ReadUncommitted(LbNȂArbNȂ)
        /// </summary>
        public void Open()
        {
            this.Open(this.isolation, false);
        }
        /// <summary>
        /// ڑJ
        /// KvȃgUNVxw肷B
        /// </summary>
        /// <remarks>ŉ_ɃbNIvVw肵ȂƁB</remarks>
        /// <param name="isolation">gUNVx</param>
        public void Open(IsolationLevel isolation)
        {
            this.Open(isolation, false);
        }

        /// <summary>
        /// ڑJ
        /// </summary>
        /// <remarks>ŉ_ɃbNIvVw肵ȂƁB</remarks>
        /// <param name="isolation">gUNVx</param>
        /// <param name="beginTransaction">gUNVJnꍇtrueݒ</param>
        public void Open(IsolationLevel isolation, bool beginTransaction)
        {
            try
            {
                if (connectionCount == 0)
                {
                    this.OpenInternal(isolation, beginTransaction);
                }
            }
            finally
            {
                connectionCount++;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="isolation"></param>
        /// <param name="beginTransaction"></param>
        protected abstract void OpenInternal(IsolationLevel isolation, bool beginTransaction);

        /// <summary>
        /// ڑJ
        /// gUNVxIsolationLevel.ReadUncommitted(LbNȂArbNȂ)
        /// </summary>
        public void connect()
        {
            this.connect(this.isolation, false);
        }
        /// <summary>
        /// ڑJ
        /// KvȃgUNVxw肷B
        /// </summary>
        /// <remarks>ŉ_ɃbNIvVw肵ȂƁB</remarks>
        /// <param name="isolation">gUNVx</param>
        public void connect(IsolationLevel isolation)
        {
            this.connect(isolation, false);
        }

        /// <summary>
        /// ڑJ
        /// </summary>
        /// <remarks>ŉ_ɃbNIvVw肵ȂƁB</remarks>
        /// <param name="isolation">gUNVx</param>
        /// <param name="beginTransaction">gUNVJnꍇtrueݒ</param>
        public void connect(IsolationLevel isolation, bool beginTransaction)
        {
            try
            {
                if (connectionCount == 0)
                {
                    this.connectInternal(isolation, beginTransaction);
                }
            }
            finally
            {
                connectionCount++;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="isolation"></param>
        /// <param name="beginTransaction"></param>
        protected virtual void connectInternal(IsolationLevel isolation, bool beginTransaction)
        {
            OpenInternal(isolation, beginTransaction);
        }
        /// <summary>
        /// ڑ.
        /// gUNVcĂ΃[obNB
        /// </summary>
        /// <remarks>̃\bhďǒAēxOpen܂ő̃\bȟĂяo͎s</remarks>
        public virtual void Close()
        {
            Close(false);
        }
        /// <summary>
        /// ڑ
        /// gUNVcĂcommitTransactionɂR~bg/[obNB
        /// </summary>
        /// <param name="commitTransaction">cĂgUNVm肷ꍇtrue</param>
        public virtual void Close(bool commitTransaction)
        {
            connectionCount--;
            if (connectionCount <= 0)
            {
                CloseInternal(commitTransaction);
                connectionCount = 0;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="commitTransaction"></param>
        protected abstract void CloseInternal(bool commitTransaction);
        /// <summary>
        /// ڑ.
        /// gUNVcĂ΃[obNB
        /// </summary>
        /// <remarks>̃\bhďǒAēxOpen܂ő̃\bȟĂяo͎s</remarks>
        public virtual void disconnect()
        {
            Close(false);
        }
        /// <summary>
        /// ڑ
        /// gUNVcĂcommitTransactionɂR~bg/[obNB
        /// </summary>
        /// <param name="commitTransaction">cĂgUNVm肷ꍇtrue</param>
        public virtual void disconnect(bool commitTransaction)
        {
            connectionCount--;
            if (connectionCount <= 0)
            {
                disconnectInternal(commitTransaction);
                connectionCount = 0;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="commitTransaction"></param>
        protected virtual void disconnectInternal(bool commitTransaction)
        {
            CloseInternal(commitTransaction);
        }

        /// <summary>
        /// gUNVJn
        /// </summary>
        public virtual void BeginTransaction()
        {
            BeginTransaction(this.isolation);
        }
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <param name="isolation">gUNVx</param>
        public virtual void BeginTransaction(IsolationLevel isolation)
        {
            try
            {
                if (transactionCount == 0)
                {
                    BeginTransactionInternal(isolation);
                }
            }
            finally
            {
                transactionCount++;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="isolation"></param>
        protected abstract void BeginTransactionInternal(IsolationLevel isolation);
        /// <summary>
        /// gUNVm
        /// </summary>
        public virtual void CommitTransaction()
        {
            transactionCount--;
            if (transactionCount <= 0)
            {
                CommitTransactionInternal();
                transactionCount = 0;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        protected abstract void CommitTransactionInternal();
        /// <summary>
        /// gUNVj
        /// </summary>
        public virtual void RollbackTransaction()
        {
            transactionCount--;
            if (transactionCount <= 0)
            {
                RollbackTransactionInternal();
                transactionCount = 0;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        protected abstract void RollbackTransactionInternal();
        /// <summary>
        /// NG[s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <returns>R}hs</returns>
        public virtual DataSet ExecuteQuery(Command command)
        {
            return ExecuteQuery(command, this.commandTimeout);
        }
        /// <summary>
        /// NG[s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        public virtual DataSet ExecuteQuery(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);

            try
            {
                DbCommand dbCommand = CreateDbCommand(command);
                dbCommand.CommandTimeout = timeout;

                DbDataAdapter adapter = this.CreateDataAdapter();
                adapter.SelectCommand = dbCommand;

                DataSet ds = new DataSet();
                int ret = adapter.Fill(ds);

                readOutputParameters(dbCommand, ref command);
                return ds;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }

        }

        /// <summary>
        /// NG[sDbDataReader𓾂B
        /// </summary>
        /// <remarks>ʓIɂ̓ptH[}X̂߂IDataReadergpB񖼂ł̃ANZX̓RXĝőȈŒ肳Ăꍇ̂ݎgp\B<p>IDataReader̃CX^XO琶łȂ̂ŁA WebServiceĂяoꍇ͎gpłȂ</p></remarks>
        /// <param name="command">sR}h</param>
        /// <returns>R}hs</returns>
        public virtual DbDataReader ExecuteReader(Command command)
        {
            return ExecuteReader(command, this.commandTimeout);
        }
        /// <summary>
        /// NG[sDbDataReader𓾂B
        /// </summary>
        /// <remarks>ʓIɂ̓ptH[}X̂߂IDataReadergpB񖼂ł̃ANZX̓RXĝőȈŒ肳Ăꍇ̂ݎgp\B<p>IDataReader̃CX^XO琶łȂ̂ŁA WebServiceĂяoꍇ͎gpłȂ</p></remarks>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        public virtual DbDataReader ExecuteReader(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);

            try
            {
                DbCommand dbCommand = CreateDbCommand(command);
                // DBR}h^CAEgݒ
                dbCommand.CommandTimeout = timeout;
                DbDataReader reader = dbCommand.ExecuteReader();
                return reader;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
            }
        }
        /// <summary>
        /// XJ[NG[(NG[ʂP̒lԂ)s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <returns>R}hs</returns>
        public virtual object ExecuteScalar(Command command)
        {
            return this.ExecuteScalar(command, this.commandTimeout);
        }
        /// <summary>
        /// XJ[NG[(NG[ʂP̒lԂ)s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        public virtual object ExecuteScalar(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);

            try
            {
                DbCommand dbCommand = CreateDbCommand(command);
                // DBR}h^CAEgݒ
                dbCommand.CommandTimeout = timeout;
                object value = dbCommand.ExecuteScalar();

                readOutputParameters(dbCommand, ref command);
                return value;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// XVNG[s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <returns>R}hs</returns>
        /// <remarks>ʓIɂ́uXVv̂߂ɎgpBXV͂邪NG[ʃZbgԂꍇExecuteQuerygB</remarks>
        public virtual int ExecuteUpdate(Command command)
        {
            return ExecuteUpdate(command, this.commandTimeout);
        }
        /// <summary>
        /// XVNG[s
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        /// <remarks>ʓIɂ́uXVv̂߂ɎgpBXV͂邪NG[ʃZbgԂꍇExecuteQuerygB</remarks>
        public virtual int ExecuteUpdate(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);
            try
            {
                DbCommand dbCommand = CreateDbCommand(command);
                // DBR}h^CAEgݒ
                dbCommand.CommandTimeout = timeout;

                int ret = dbCommand.ExecuteNonQuery();

                if (HasReturnValue(dbCommand))
                {
                    ret = GetReturnValue(dbCommand);
                }
                readOutputParameters(dbCommand, ref command);

                return ret;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        /// <summary>
        /// XgAhvV[Ẃu߂lvR}hɐݒ肳Ă邩`FbN
        /// ߂lɐݒ肳ϐ"@RETURN_VALUE"łȂꍇɎNXŏ㏑B
        /// </summary>
        /// <param name="command">Ώۂ̃R}h</param>
        /// <returns>u߂lvR}hɐݒ肳Ătrue</returns>
        protected virtual bool HasReturnValue(DbCommand command)
        {
            if (command.Parameters.Contains("@RETURN_VALUE")) return true;
            return false;
        }
        /// <summary>
        /// u߂lv擾
        /// ߂lɐݒ肳ϐ"@RETURN_VALUE"łȂꍇɎNXŏ㏑B
        /// </summary>
        /// <param name="command">ΏۃR}h</param>
        /// <returns>߂l</returns>
        protected virtual int GetReturnValue(DbCommand command)
        {
            if (command.Parameters.Contains("@RETURN_VALUE")) return OFW.Util.NumberUtil.IntValue(command.Parameters["@RETURN_VALUE"].Value);
            return 0;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="dbcommand"></param>
        /// <param name="baseCommand"></param>
        protected void readOutputParameters(DbCommand dbcommand, ref Command baseCommand)
        {
            foreach (Parameter p in baseCommand.Parameters)
            {
                if (p.ParameterDirection == ParameterDirection.Output)
                {
                    p.ParameterValue = dbcommand.Parameters[p.ParameterName].Value;
                    continue;
                }
                if (p.ParameterDirection == ParameterDirection.InputOutput)
                {
                    p.ParameterValue = dbcommand.Parameters[p.ParameterName].Value;
                    continue;
                }
            }

        }
        /// <summary>
        /// NG[săVACY
        /// Connection̎NX܂WebServiceȊO͌Ăяos
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <returns>R}hs</returns>
        /// <remarks>Connection̎NX܂WebServiceȊO͌Ăяos</remarks>
        public virtual string ExecuteQueryAsSerialized(Command command)
        {
            return ExecuteQueryAsSerialized(command, this.commandTimeout);
        }
        /// <summary>
        /// NG[săVACY
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        public virtual string ExecuteQueryAsSerialized(Command command, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name,"start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);
            try
            {
                DataSet result = ExecuteQuery(command, timeout);
                return SerializeDataSet(result);

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        /// <summary>
        /// NG[săe[us^CṽXgԂ
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="command">sR}h</param>
        /// <returns>w^̃GeBeB܂ރXgBΏۂnullł͂Ȃ̃XgԂ</returns>
        /// <remarks>^ɐݒ肵^̃GeBeB̃XgԂBDataReadergĂsAGeBeB̃tB[h`ƑIʂ̗񂪈vꍇ̂ݎgpłB</remarks>
        public virtual List<T> ExecuteQueryAsTableRows<T>(Command command) where T : IEntity, new()
        {
            return ExecuteQueryAsTableRows<T>(command, this.commandTimeout);
        }
        /// <summary>
        /// NG[săe[us^CṽXgԂ
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="command">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>w^̃GeBeB܂ރXgBΏۂnullł͂Ȃ̃XgԂ</returns>
        /// <remarks>^ɐݒ肵^̃GeBeB̃XgԂBDataReadergĂsAGeBeB̃tB[h`ƑIʂ̗񂪈vꍇ̂ݎgpłB</remarks>
        public virtual List<T> ExecuteQueryAsTableRows<T>(Command command, int timeout) where T : IEntity, new()
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);
            List<T> list = new List<T>();
            try
            {
                DbDataReader reader = ExecuteReader(command, timeout);
                while (reader.Read())
                {
                    T row = new T();
                    row.Map(reader);
                    list.Add(row);
                }
                reader.Close();
                return list;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, command);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }
        /// <summary>
        /// NG[ꊇs
        /// </summary>
        /// <param name="commands">sR}h</param>
        /// <returns>R}hs</returns>
        /// <remarks>ẴNG[͑SẴNG[vfcĂꍇɌgpł(X̃NG[ɓnp[^ǂȂ̂ʂtȂB)߁ANG[̎s܂łǂ̃NGŝs̏ꍇgpłȂB̑CommandIuWFNg𕡐ė߂ĂAꊇĎs邽߂ɎgpB</remarks>
        public virtual DataSet ExecuteQueryBatch(Command[] commands)
        {
            return ExecuteQueryBatch(commands, this.commandTimeout);
        }
        /// <summary>
        /// NG[ꊇs
        /// </summary>
        /// <param name="commands">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        /// <remarks>ẴNG[͑SẴNG[vfcĂꍇɌgpł(X̃NG[ɓnp[^ǂȂ̂ʂtȂB)߁ANG[̎s܂łǂ̃NGŝs̏ꍇgpłȂB̑CommandIuWFNg𕡐ė߂ĂAꊇĎs邽߂ɎgpB</remarks>
        public virtual DataSet ExecuteQueryBatch(Command[] commands, int timeout)
        {
            
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            foreach(Command command in commands)logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, command);

            try
            {
                int i = 0;
                DataSet result = new DataSet();
                foreach (Command c in commands)
                {
                    DataSet aresult = this.ExecuteQuery(c, timeout);
                    foreach (DataTable t in aresult.Tables)
                    {
                        DataTable tcopy = t.Copy();

                        tcopy.TableName = "Table" + i.ToString();
                        result.Tables.Add(tcopy);
                        i++;
                    }
                }
                return result;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, commands);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// NG[ꊇs
        /// </summary>
        /// <param name="commands">sR}h</param>
        /// <returns>R}hs</returns>
        /// <remarks>ẴNG[͑SẴNG[vfcĂꍇɌgpł(X̃NG[ɓnp[^ǂȂ̂ʂtȂB)߁ANG[̎s܂łǂ̃NGŝs̏ꍇgpłȂB̑CommandIuWFNg𕡐ė߂ĂAꊇĎs邽߂ɎgpB</remarks>
        public virtual int ExecuteUpdateBatch(Command[] commands)
        {
            return ExecuteUpdateBatch(commands, this.commandTimeout);
        }

        /// <summary>
        /// NG[ꊇs
        /// </summary>
        /// <param name="commands">sR}h</param>
        /// <param name="timeout">^CAEg</param>
        /// <returns>R}hs</returns>
        /// <remarks>ẴNG[͑SẴNG[vfcĂꍇɌgpł(X̃NG[ɓnp[^ǂȂ̂ʂtȂB)߁ANG[̎s܂łǂ̃NGŝs̏ꍇgpłȂB̑CommandIuWFNg𕡐ė߂ĂAꊇĎs邽߂ɎgpB<p>Ŏw肷^CAEglׂ͂ẴR}hI܂ł̃^CAEgł͂ȂX̃R}hsł̃^CAEgƂȂB</p></remarks>
        public virtual int ExecuteUpdateBatch(Command[] commands, int timeout)
        {
            logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "start " + this.name);
            try
            {
                int result = 0;
                foreach (Command c in commands)
                {
                    int aresult = this.ExecuteUpdate(c, timeout);
                    result += aresult;
                }
                return result;

            }
            catch (DbException dbex)
            {
                ConnectionException newEx = this.BuildException(dbex, commands);
                ErrorHandler.ErrorMessageBuilder builder = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(newEx, currentUser);
                builder.WriteLog();
                throw newEx;
            }
            finally
            {
                logger.Log(LogLevel.DEBUG, currentUser, MethodBase.GetCurrentMethod().Name, "end " + this.name);
            }
        }

        /// <summary>
        /// spR}h𐶐
        /// </summary>
        /// <param name="command">sR}h</param>
        /// <returns>DBR}h</returns>
        protected abstract DbCommand CreateDbCommand(Command command);
        /// <summary>
        /// ǂݎ悤̃f[^A_v^[𐶐
        /// </summary>
        /// <returns>f[^A_v^[</returns>
        protected abstract DbDataAdapter CreateDataAdapter();
        /// <summary>
        /// VACY
        /// </summary>
        /// <param name="data">VACYΏ</param>
        /// <returns>VACY</returns>
        string SerializeDataSet(DataSet data)
        {
            DataSetJSON serializer = new DataSetJSON();

            StringWriter writer = new StringWriter();
            serializer.SerializeDataSet(writer, data);
            return writer.ToString();//TODO:VACY@\ 
        }

        /// <summary>
        /// f[^x[Xp̈p
        /// </summary>
        /// <param name="value">pΏۂ̕</param>
        /// <returns>p{</returns>
        /// <remarks>p[^l𒼐ڃNG[ɖߍނ߂ɎgpBʓIɂ̓p[^NG[łقƂǂ̃p[^ł̂ŕsvł͂邪Aǁ[[[[[[ĂoȂgpĂ悢B<p>gƂquoteRꂪȂK`FbN鎖B܂Alɂ͎gpĂ͂ȂȂB</p></remarks>
        public virtual string Quote(string value)
        {
            //TODO:quoteStyleɂU蕪
            StringBuilder builder = new StringBuilder(value);
            builder.Replace("'", "''");

            return "'" + builder.ToString() + "'";

        }
        /// <summary>
        /// ʎqNH[gBftHgł͉ȂB
        /// </summary>
        /// <param name="identifier"></param>
        /// <returns></returns>
        /// <remarks>QuotedIdentifiertruȅꍇɊł͓dpň͂ށB</remarks>
        public virtual string QuoteIdentifier(string identifier)
        {
            string quoteBegin = quoteIdentifier ? "\"" : "";
            string quoteEnd = quoteIdentifier ? "\"" : "";
            return quoteBegin + identifier + quoteEnd;
        }
        /// <summary>
        /// 񖼂̂߂̃NH[gBftHgł͓dpň͂ށB
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <returns></returns>
        public virtual string QuoteColumnName(string tableName,string columnName)
        {
            return QuoteIdentifier( tableName ) + "." + QuoteIdentifier( columnName );
        }
        /// <summary>
        /// e[u̎ʎqpsBʏ "(_uNH[e[V) ꍇɂĂ"`"Ƃ"["Ƃ)
        /// </summary>
        /// <param name="dbname"></param>
        /// <param name="schema"></param>
        /// <param name="table"></param>
        /// <returns></returns>
        public virtual string QuoteTableName(string dbname, string schema, string table)
        {
            string quoted = "";
            if (dbname == "")
            {
            }
            else
            {
                quoted += QuoteIdentifier( dbname ) + ".";
            }
            if (schema == "")
            {
                if (quoted == "")
                {
                }
                else
                {
                    quoted += ".";
                }
            }
            else
            {
                quoted += QuoteIdentifier( schema ) +  ".";
            }
            quoted += QuoteIdentifier( table );
            return quoted;

        }
        /// <summary>
        /// wildcardGXP[v
        /// </summary>
        /// <param name="value">GXP[vΏۂ̕</param>
        /// <returns>wildcardGXP[v</returns>
        /// <remarks>LIKEZqgČ鎞͒lɃChJ[hȂꍇɎgB</remarks>
        public virtual string EscapeWildCards(string value)
        {
            //TODO:quoteStyleɂU蕪
            StringBuilder builder = new StringBuilder(value);
            builder.Replace("%", "[%]");
            builder.Replace(";", "[;]");
            builder.Replace("_", "[_]");

            return builder.ToString();

        }
        /// <summary>
        /// ڑ̃VXeԂ擾
        /// </summary>
        /// <returns>VXe</returns>
        public abstract DateTime SystemDate();
        /// <summary>
        /// ŌIdentity
        /// </summary>
        /// <returns>ŌIdentity</returns>
        public virtual int GetLastIdentity()
        {
            return 0;
        }
        /// <summary>
        /// ŌIdentity
        /// </summary>
        /// <param name="identityName">identitÿׂ̖OBʓIɂ"SEQUENCE"̖O</param>
        /// <returns>ŌIdentity</returns>
        public virtual int GetLastIdentity(string identityName)
        {
            return 0;
        }

        /// <summary>
        /// XgĕɂB
        /// </summary>
        /// <param name="list">ɂ郊Xg</param>
        /// <param name="glue">ɂ؂蕶</param>
        /// <param name="quote">p邩</param>
        /// <returns></returns>
        public virtual string Implode(IEnumerable list, string glue, bool quote)
        {
            StringBuilder builder = new StringBuilder();
            foreach (object o in list)
            {
                if (builder.Length > 0) builder.Append(glue);
                if (quote)
                {
                    builder.Append(Quote(o.ToString()));
                }
                else
                {
                    builder.Append(o.ToString());
                }
            }
            return builder.ToString();
        }
        /// <summary>
        /// ͒lDBp̒lɕύX
        /// </summary>
        /// <param name="value">Ώۂ̒l</param>
        /// <returns>null̂ƂDBNull.ValueAłȂΌ̒l</returns>
        public static object FixValue(object value)
        {
            if (value == null) return DBNull.Value;

            return value;
        }
        /// <summary>
        /// DBlVXep̒lɕύX
        /// </summary>
        /// <param name="value">DataRow̗ADataReader̗</param>
        /// <returns></returns>
        public static object Filter(object value)
        {
            if (value == DBNull.Value) return null;

            return value;
        }
        /// <summary>
        /// e[u\擾
        /// TODO:
        /// </summary>
        /// <param name="tableName">e[u</param>
        /// <returns>e[u\</returns>
        public virtual  IEntityProperty DescribeTable(string tableName)
        {

            return null;
        }
        /// <summary>
        /// e[u\擾
        /// TODO:
        /// </summary>
        /// <param name="tableName">e[u</param>
        /// <returns>e[u\</returns>
        public virtual DataSet ListTables(string tableName)
        {

            return null;
        }
        /// <summary>
        /// XgAhp[^擾
        /// TODO:
        /// </summary>
        /// <param name="procedureName">XgAh</param>
        /// <returns>XgAhp[^\</returns>
        public virtual DataSet DescribeStoredProcedure(string procedureName)
        {
            return null;
        }
        /// <summary>
        /// e[u`擾
        /// TODO:INFORMATION_SCHEMAg悤ɁB
        /// </summary>
        /// <remarks>sp_columnsQ</remarks>
        /// <param name="tableName">Ώۃe[u</param>
        /// <returns>sp_columnš</returns>
        public virtual DataSet GetColumnInfo(string tableName)
        {
            string sp_columns = "sp_columns";
            Command command = new Command(sp_columns, CommandType.StoredProcedure);
            command.SetParameter(new Parameter("@table_name", DbType.String, tableName));

            DataSet result = this.ExecuteQuery(command);

            return result;
        }
        /// <summary>
        /// XgAḧ`擾
        /// TODO:INFORMATION_SCHEMAg悤ɁB
        /// </summary>
        /// <remarks>sp_sproc_columnsQ</remarks>
        /// <param name="procName">ΏۃXgAh</param>
        /// <returns>sp_sproc_columnš</returns>
        public virtual DataSet GetSpColumnInfo(string procName)
        {
            string sp_columns = "sp_sproc_columns";
            Command command = new Command(sp_columns, CommandType.StoredProcedure);
            command.SetParameter(new Parameter("@procedure_name", DbType.String, procName));

            DataSet result = this.ExecuteQuery(command);

            return result;
        }
        /// <summary>
        /// e[uL[`擾
        /// TODO:INFORMATION_SCHEMAg悤ɁB
        /// </summary>
        /// <remarks>sp_columnsQ</remarks>
        /// <param name="tableName">Ώۃe[u</param>
        /// <returns>sp_columnš</returns>
        public virtual DataSet GetPrimaryKeys(string tableName)
        {
            string sp_columns = "sp_pkeys";
            Command command = new Command(sp_columns, CommandType.StoredProcedure);
            command.SetParameter(new Parameter("@table_name", DbType.String, tableName));

            DataSet result = this.ExecuteQuery(command);

            return result;
        }
        /// <summary>
        /// e[uRg擾
        /// </summary>
        /// <remarks>sp_columnsQ</remarks>
        /// <param name="tableName">Ώۃe[u</param>
        /// <returns>sp_columnš</returns>
        public virtual DataSet GetColumnComments(string tableName)
        {
            string qry = @"
SELECT   *
FROM   ::fn_listextendedproperty (NULL, 'user', 'dbo', 'table', @TableName, 'column', default) xp
where xp.name = N'MS_Description'
";
            Command command = new Command(qry, CommandType.Text);
            command.SetParameter(new Parameter("@TableName", DbType.String, tableName));


            DataSet result = this.ExecuteQuery(command);

            return result;
        }
        /// <summary>
        /// ̐ڑɑΉOgݗĂ
        /// </summary>
        /// <param name="ex"></param>
        /// <param name="commands"></param>
        /// <returns></returns>
        protected abstract ConnectionException BuildException(DbException ex,params Command[] commands);
        #region IDisposable o

        /// <summary>
        /// Dispose
        /// 
        /// ڑĂȂꍇAgUNVjĐڑB
        /// (web serviceœ삷ꍇlB)
        /// </summary>
        public virtual void Dispose()
        {
            //force close
            if (connectionCount > 0)
            {
                CloseInternal(false);
                connectionCount = 0;
                transactionCount = 0;
            }
        }
        #endregion

        #region RlNVT|[g@\
        /// <summary>
        /// TOPT|[gĂ邩
        /// </summary>
        /// <returns></returns>
        public virtual bool supportsTop()
        {
            return true;//{SQLT[o[B̃RlNV̏ꍇlimitg
        }
        /// <summary>
        /// LIMITT|[gĂ邩
        /// </summary>
        /// <returns></returns>
        public virtual bool supportsLimit()
        {
            return false;//{SQLT[o[B̃RlNV̏ꍇlimitg
        }
        /// <summary>
        /// OffsetT|[gĂ邩
        /// </summary>
        /// <returns></returns>
        public virtual bool supportsOffset()
        {
            return false;//{SQLT[o[B̃RlNV̏ꍇlimitg
        }
        /// <summary>
        /// Otp[^̐擪ɕtL
        /// </summary>
        /// <returns></returns>
        public virtual string NamedParameterPrefix()
        {
            return "@";
        }
        /// <summary>
        /// Otp[^̖ɕtL
        /// </summary>
        /// <returns></returns>
        public virtual string NamedParameterSuffix()
        {
            return "";
        }
        /// <summary>
        /// p[^
        /// </summary>
        /// <param name="baseName"></param>
        /// <returns></returns>
        public virtual string buildParameterName(string baseName)
        {
            return NamedParameterPrefix() + baseName.Replace(".", "__") + NamedParameterSuffix();
        }
        #endregion

        /// <summary>
        /// ̐ڑɂ킹f[^\[X𓾂B
        /// </summary>
        /// <returns></returns>
        public virtual DataSource<TEntity> getDataSource<TEntity>() where TEntity : Entity, new()
        {
            DataSource<TEntity> datasource = new DataSource<TEntity>();
            datasource.setConnection(this);
            return datasource;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public virtual Expressions.ExpressionFactory getExpressionFactory()
        {
            return new Expressions.ExpressionFactory(this);
        }

    }
}
